/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;

@PublicEvolving
public class TableId
implements Serializable {
    @Nullable
    private final String namespace;
    @Nullable
    private final String schemaName;
    private final String tableName;
    private transient int cachedHashCode;

    private TableId(@Nullable String namespace, @Nullable String schemaName, String tableName) {
        this.namespace = namespace;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName);
    }

    public static TableId tableId(String namespace, String schemaName, String tableName) {
        return new TableId(Objects.requireNonNull(namespace), Objects.requireNonNull(schemaName), tableName);
    }

    public static TableId tableId(String schemaName, String tableName) {
        return new TableId(null, Objects.requireNonNull(schemaName), tableName);
    }

    public static TableId tableId(String tableName) {
        return new TableId(null, null, tableName);
    }

    public static TableId parse(String tableId) {
        String[] parts = Objects.requireNonNull(tableId).split("\\.");
        if (parts.length == 3) {
            return TableId.tableId(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 2) {
            return TableId.tableId(parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return TableId.tableId(parts[0]);
        }
        throw new IllegalArgumentException("Invalid tableId: " + tableId);
    }

    public String identifier() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            if (this.schemaName == null || this.schemaName.isEmpty()) {
                return this.tableName;
            }
            return this.schemaName + "." + this.tableName;
        }
        return this.namespace + "." + this.schemaName + "." + this.tableName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableId that = (TableId)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = Objects.hash(this.namespace, this.schemaName, this.tableName);
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return this.identifier();
    }
}

