/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.utils;

import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerTopicSelector;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.utils.SourceRecordUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.connectors.sqlserver.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerTypeUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;

public class SqlServerUtils {
    public static Object[] queryMinMax(JdbcConnection jdbc, TableId tableId, String columnName) throws SQLException {
        String minMaxQuery = String.format("SELECT MIN(%s), MAX(%s) FROM %s", SqlServerUtils.quote(columnName), SqlServerUtils.quote(columnName), SqlServerUtils.quote(tableId));
        return jdbc.queryAndMap(minMaxQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minMaxQuery));
            }
            return SourceRecordUtils.rowToArray(rs, 2);
        });
    }

    public static long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        String useDatabaseStatement = String.format("USE %s;", SqlServerUtils.quote(tableId.catalog()));
        String rowCountQuery = String.format("SELECT Total_Rows = SUM(st.row_count) FROM sys.dm_db_partition_stats st WHERE object_name(object_id) = '%s' AND index_id < 2;", tableId.table());
        jdbc.executeWithoutCommitting(useDatabaseStatement);
        return jdbc.queryAndMap(rowCountQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
            }
            return rs.getLong(1);
        });
    }

    public static Object queryMin(JdbcConnection jdbc, TableId tableId, String columnName, Object excludedLowerBound) throws SQLException {
        String minQuery = String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", SqlServerUtils.quote(columnName), SqlServerUtils.quote(tableId), SqlServerUtils.quote(columnName));
        return jdbc.prepareQueryAndMap(minQuery, ps -> ps.setObject(1, excludedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minQuery));
            }
            return rs.getObject(1);
        });
    }

    public static Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, String splitColumnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = SqlServerUtils.quote(splitColumnName);
        String query = String.format("SELECT MAX(%s) FROM (SELECT TOP (%s) %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) AS T", quotedColumn, chunkSize, quotedColumn, SqlServerUtils.quote(tableId), quotedColumn, quotedColumn);
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, includedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            return rs.getObject(1);
        });
    }

    public static Column getSplitColumn(Table table, @Nullable String chunkKeyColumn) {
        List<Column> primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        if (chunkKeyColumn != null) {
            Optional<Column> targetPkColumn = primaryKeys.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetPkColumn.isPresent()) {
                return targetPkColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the primary key [%s] of the table %s.", chunkKeyColumn, primaryKeys.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return primaryKeys.get(0);
    }

    public static RowType getSplitType(Column splitColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)splitColumn.name(), (DataType)SqlServerTypeUtils.fromDbzColumn(splitColumn))}).getLogicalType();
    }

    public static Offset getLsn(SourceRecord record) {
        return SqlServerUtils.getLsnPosition(record.sourceOffset());
    }

    public static LsnOffset getLsnPosition(Map<String, ?> offset) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        Lsn changeLsn = Lsn.valueOf((String)offsetStrMap.get("change_lsn"));
        Lsn commitLsn = Lsn.valueOf((String)offsetStrMap.get("commit_lsn"));
        return new LsnOffset(changeLsn, commitLsn, null);
    }

    public static LsnOffset currentLsn(SqlServerConnection connection) {
        try {
            Lsn maxLsn = connection.getMaxTransactionLsn(connection.database());
            return new LsnOffset(maxLsn, maxLsn, null);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static String buildSplitScanQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit) {
        return SqlServerUtils.buildSplitQuery(tableId, pkRowType, isFirstSplit, isLastSplit, -1, true);
    }

    public static PreparedStatement readTableSplitDataStatement(JdbcConnection jdbc, String sql, boolean isFirstSplit, boolean isLastSplit, Object[] splitStart, Object[] splitEnd, int primaryKeyNum, int fetchSize) {
        try {
            PreparedStatement statement = SqlServerUtils.initStatement(jdbc, sql, fetchSize);
            if (isFirstSplit && isLastSplit) {
                return statement;
            }
            if (isFirstSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitEnd[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                }
            } else if (isLastSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                }
            } else {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                    statement.setObject(i + 1 + 2 * primaryKeyNum, splitEnd[i]);
                }
            }
            return statement;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build the split data read statement.", e);
        }
    }

    public static SqlServerDatabaseSchema createSqlServerDatabaseSchema(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection) {
        TopicSelector<TableId> topicSelector = SqlServerTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        SqlServerValueConverters valueConverters = new SqlServerValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.binaryHandlingMode());
        return new SqlServerDatabaseSchema(connectorConfig, connection.getDefaultValueConverter(), valueConverters, topicSelector, schemaNameAdjuster);
    }

    private static String getPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next());
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSplitQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, int limitSize, boolean isScanningData) {
        StringBuilder sql;
        String condition;
        if (isFirstSplit && isLastSplit) {
            condition = null;
        } else if (isFirstSplit) {
            sql = new StringBuilder();
            SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            condition = sql.toString();
        } else if (isLastSplit) {
            sql = new StringBuilder();
            SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            condition = sql.toString();
        } else {
            sql = new StringBuilder();
            SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            sql.append(" AND ");
            SqlServerUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            condition = sql.toString();
        }
        if (isScanningData) {
            return SqlServerUtils.buildSelectWithRowLimits(tableId, limitSize, "*", Optional.ofNullable(condition), Optional.empty());
        }
        String orderBy = pkRowType.getFieldNames().stream().collect(Collectors.joining(", "));
        return SqlServerUtils.buildSelectWithBoundaryRowLimits(tableId, limitSize, SqlServerUtils.getPrimaryKeyColumnsProjection(pkRowType), SqlServerUtils.getMaxPrimaryKeyColumnsProjection(pkRowType), Optional.ofNullable(condition), orderBy);
    }

    private static PreparedStatement initStatement(JdbcConnection jdbc, String sql, int fetchSize) throws SQLException {
        Connection connection = jdbc.connection();
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        return statement;
    }

    private static String getMaxPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append("MAX(" + (String)fieldNamesIt.next() + ")");
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (limit > 0) {
            sql.append(" TOP( ").append(limit).append(") ");
        }
        sql.append(projection).append(" FROM ");
        sql.append(SqlServerUtils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (orderBy.isPresent()) {
            sql.append(" ORDER BY ").append(orderBy.get());
        }
        return sql.toString();
    }

    private static String quoteSchemaAndTable(TableId tableId) {
        StringBuilder quoted = new StringBuilder();
        if (tableId.schema() != null && !tableId.schema().isEmpty()) {
            quoted.append(SqlServerUtils.quote(tableId.schema())).append(".");
        }
        quoted.append(SqlServerUtils.quote(tableId.table()));
        return quoted.toString();
    }

    public static String quote(String dbOrTableName) {
        return "[" + dbOrTableName + "]";
    }

    public static String quote(TableId tableId) {
        return "[" + tableId.schema() + "].[" + tableId.table() + "]";
    }

    private static void addPrimaryKeyColumnsToCondition(RowType pkRowType, StringBuilder sql, String predicate) {
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next()).append(predicate);
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private static String buildSelectWithBoundaryRowLimits(TableId tableId, int limit, String projection, String maxColumnProjection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(maxColumnProjection);
        sql.append(" FROM (");
        sql.append("SELECT ");
        sql.append(" TOP( ").append(limit).append(") ");
        sql.append(projection);
        sql.append(" FROM ");
        sql.append(SqlServerUtils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy);
        sql.append(") T");
        return sql.toString();
    }
}

