/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Command;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Method;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AMQChannel;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AMQConnection;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AMQContentHeader;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.CommandAssembler;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.Frame;

public class AMQCommand
implements Command {
    public static final int EMPTY_FRAME_SIZE = 8;
    private final CommandAssembler assembler;

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(Method method) {
        this(method, null, null);
    }

    public AMQCommand(Method method, AMQContentHeader contentHeader, byte[] body) {
        this.assembler = new CommandAssembler((org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.Method)method, contentHeader, body);
    }

    @Override
    public org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.Method getMethod() {
        return this.assembler.getMethod();
    }

    @Override
    public AMQContentHeader getContentHeader() {
        return this.assembler.getContentHeader();
    }

    @Override
    public byte[] getContentBody() {
        return this.assembler.getContentBody();
    }

    public boolean handleFrame(Frame f) throws IOException {
        return this.assembler.handleFrame(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQChannel channel) throws IOException {
        int channelNumber = channel.getChannelNumber();
        AMQConnection connection = channel.getConnection();
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.Method m = this.assembler.getMethod();
            if (m.hasContent()) {
                int bodyPayloadMax;
                byte[] body = this.assembler.getContentBody();
                Frame headerFrame = this.assembler.getContentHeader().toFrame(channelNumber, body.length);
                int frameMax = connection.getFrameMax();
                boolean cappedFrameMax = frameMax > 0;
                int n = bodyPayloadMax = cappedFrameMax ? frameMax - 8 : body.length;
                if (cappedFrameMax && headerFrame.size() > frameMax) {
                    String msg = String.format("Content headers exceeded max frame size: %d > %d", headerFrame.size(), frameMax);
                    throw new IllegalArgumentException(msg);
                }
                connection.writeFrame(m.toFrame(channelNumber));
                connection.writeFrame(headerFrame);
                for (int offset = 0; offset < body.length; offset += bodyPayloadMax) {
                    int remaining = body.length - offset;
                    int fragmentLength = remaining < bodyPayloadMax ? remaining : bodyPayloadMax;
                    Frame frame = Frame.fromBodyFragment(channelNumber, body, offset, fragmentLength);
                    connection.writeFrame(frame);
                }
            } else {
                connection.writeFrame(m.toFrame(channelNumber));
            }
        }
        connection.flush();
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean suppressBody) {
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            return "" + '{' + this.assembler.getMethod() + ", " + this.assembler.getContentHeader() + ", " + AMQCommand.contentBodyStringBuilder(this.assembler.getContentBody(), suppressBody) + '}';
        }
    }

    private static StringBuilder contentBodyStringBuilder(byte[] body, boolean suppressBody) {
        try {
            if (suppressBody) {
                return new StringBuilder().append(body.length).append(" bytes of payload");
            }
            return new StringBuilder().append('\"').append(new String(body, "UTF-8")).append('\"');
        }
        catch (Exception e) {
            return new StringBuilder().append('|').append(body.length).append('|');
        }
    }

    public static void checkPreconditions() {
        AMQCommand.checkEmptyFrameSize();
    }

    private static void checkEmptyFrameSize() {
        Frame f = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            f.writeTo(new DataOutputStream(s));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("IOException while checking EMPTY_FRAME_SIZE");
        }
        int actualLength = s.toByteArray().length;
        if (8 != actualLength) {
            throw new IllegalStateException("Internal error: expected EMPTY_FRAME_SIZE(8) is not equal to computed value: " + actualLength);
        }
    }
}

