/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.rabbitmq.shaded.com.rabbitmq.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.BlockedCallback;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.BlockedListener;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Channel;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.ExceptionHandler;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.ShutdownNotifier;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.UnblockedCallback;

public interface Connection
extends ShutdownNotifier,
Closeable {
    public InetAddress getAddress();

    public int getPort();

    public int getChannelMax();

    public int getFrameMax();

    public int getHeartbeat();

    public Map<String, Object> getClientProperties();

    public String getClientProvidedName();

    public Map<String, Object> getServerProperties();

    public Channel createChannel() throws IOException;

    public Channel createChannel(int var1) throws IOException;

    default public Optional<Channel> openChannel() throws IOException {
        return Optional.ofNullable(this.createChannel());
    }

    default public Optional<Channel> openChannel(int channelNumber) throws IOException {
        return Optional.ofNullable(this.createChannel(channelNumber));
    }

    @Override
    public void close() throws IOException;

    public void close(int var1, String var2) throws IOException;

    public void close(int var1) throws IOException;

    public void close(int var1, String var2, int var3) throws IOException;

    public void abort();

    public void abort(int var1, String var2);

    public void abort(int var1);

    public void abort(int var1, String var2, int var3);

    public void addBlockedListener(BlockedListener var1);

    public BlockedListener addBlockedListener(BlockedCallback var1, UnblockedCallback var2);

    public boolean removeBlockedListener(BlockedListener var1);

    public void clearBlockedListeners();

    public ExceptionHandler getExceptionHandler();

    public String getId();

    public void setId(String var1);
}

