/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq.common;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.ConnectionFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RMQConnectionConfig.class);
    private static final long DEFAULT_DELIVERY_TIMEOUT = 30000L;
    private String host;
    private Integer port;
    private String virtualHost;
    private String username;
    private String password;
    private String uri;
    private Integer networkRecoveryInterval;
    private Boolean automaticRecovery;
    private Boolean topologyRecovery;
    private Integer connectionTimeout;
    private Integer requestedChannelMax;
    private Integer requestedFrameMax;
    private Integer requestedHeartbeat;
    private Integer prefetchCount;
    private final long deliveryTimeout;

    private RMQConnectionConfig(String host, Integer port, String virtualHost, String username, String password, Integer networkRecoveryInterval, Boolean automaticRecovery, Boolean topologyRecovery, Integer connectionTimeout, Integer requestedChannelMax, Integer requestedFrameMax, Integer requestedHeartbeat, Integer prefetchCount, Long deliveryTimeout) {
        Preconditions.checkNotNull((Object)host, (String)"host can not be null");
        Preconditions.checkNotNull((Object)port, (String)"port can not be null");
        Preconditions.checkNotNull((Object)virtualHost, (String)"virtualHost can not be null");
        Preconditions.checkNotNull((Object)username, (String)"username can not be null");
        Preconditions.checkNotNull((Object)password, (String)"password can not be null");
        Preconditions.checkArgument((deliveryTimeout == null || deliveryTimeout > 0L ? 1 : 0) != 0, (Object)"deliveryTimeout must be positive");
        this.host = host;
        this.port = port;
        this.virtualHost = virtualHost;
        this.username = username;
        this.password = password;
        this.networkRecoveryInterval = networkRecoveryInterval;
        this.automaticRecovery = automaticRecovery;
        this.topologyRecovery = topologyRecovery;
        this.connectionTimeout = connectionTimeout;
        this.requestedChannelMax = requestedChannelMax;
        this.requestedFrameMax = requestedFrameMax;
        this.requestedHeartbeat = requestedHeartbeat;
        this.prefetchCount = prefetchCount;
        this.deliveryTimeout = Optional.ofNullable(deliveryTimeout).orElse(30000L);
    }

    private RMQConnectionConfig(String uri, Integer networkRecoveryInterval, Boolean automaticRecovery, Boolean topologyRecovery, Integer connectionTimeout, Integer requestedChannelMax, Integer requestedFrameMax, Integer requestedHeartbeat, Integer prefetchCount, Long deliveryTimeout) {
        Preconditions.checkNotNull((Object)uri, (String)"Uri can not be null");
        Preconditions.checkArgument((deliveryTimeout == null || deliveryTimeout > 0L ? 1 : 0) != 0, (Object)"deliveryTimeout must be positive");
        this.uri = uri;
        this.networkRecoveryInterval = networkRecoveryInterval;
        this.automaticRecovery = automaticRecovery;
        this.topologyRecovery = topologyRecovery;
        this.connectionTimeout = connectionTimeout;
        this.requestedChannelMax = requestedChannelMax;
        this.requestedFrameMax = requestedFrameMax;
        this.requestedHeartbeat = requestedHeartbeat;
        this.prefetchCount = prefetchCount;
        this.deliveryTimeout = Optional.ofNullable(deliveryTimeout).orElse(30000L);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public Boolean isAutomaticRecovery() {
        return this.automaticRecovery;
    }

    public Boolean isTopologyRecovery() {
        return this.topologyRecovery;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public Integer getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public Integer getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public Optional<Integer> getPrefetchCount() {
        return Optional.ofNullable(this.prefetchCount);
    }

    public long getDeliveryTimeout() {
        return this.deliveryTimeout;
    }

    public ConnectionFactory getConnectionFactory() throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        ConnectionFactory factory = new ConnectionFactory();
        if (this.uri != null && !this.uri.isEmpty()) {
            try {
                factory.setUri(this.uri);
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to parse uri", (Throwable)e);
                throw e;
            }
            catch (KeyManagementException e) {
                LOG.error("Failed to initialize ssl context.", (Throwable)e);
                throw e;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Failed to setup ssl factory.", (Throwable)e);
                throw e;
            }
        } else {
            factory.setHost(this.host);
            factory.setPort(this.port);
            factory.setVirtualHost(this.virtualHost);
            factory.setUsername(this.username);
            factory.setPassword(this.password);
        }
        if (this.automaticRecovery != null) {
            factory.setAutomaticRecoveryEnabled(this.automaticRecovery);
        }
        if (this.connectionTimeout != null) {
            factory.setConnectionTimeout(this.connectionTimeout);
        }
        if (this.networkRecoveryInterval != null) {
            factory.setNetworkRecoveryInterval(this.networkRecoveryInterval);
        }
        if (this.requestedHeartbeat != null) {
            factory.setRequestedHeartbeat(this.requestedHeartbeat);
        }
        if (this.topologyRecovery != null) {
            factory.setTopologyRecoveryEnabled(this.topologyRecovery);
        }
        if (this.requestedChannelMax != null) {
            factory.setRequestedChannelMax(this.requestedChannelMax);
        }
        if (this.requestedFrameMax != null) {
            factory.setRequestedFrameMax(this.requestedFrameMax);
        }
        return factory;
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String virtualHost;
        private String username;
        private String password;
        private Integer networkRecoveryInterval;
        private Boolean automaticRecovery;
        private Boolean topologyRecovery;
        private Integer connectionTimeout;
        private Integer requestedChannelMax;
        private Integer requestedFrameMax;
        private Integer requestedHeartbeat;
        private Integer prefetchCount;
        private Long deliveryTimeout;
        private String uri;

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setVirtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
            return this;
        }

        public Builder setUserName(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setTopologyRecoveryEnabled(boolean topologyRecovery) {
            this.topologyRecovery = topologyRecovery;
            return this;
        }

        public Builder setRequestedHeartbeat(int requestedHeartbeat) {
            this.requestedHeartbeat = requestedHeartbeat;
            return this;
        }

        public Builder setRequestedFrameMax(int requestedFrameMax) {
            this.requestedFrameMax = requestedFrameMax;
            return this;
        }

        public Builder setRequestedChannelMax(int requestedChannelMax) {
            this.requestedChannelMax = requestedChannelMax;
            return this;
        }

        public Builder setNetworkRecoveryInterval(int networkRecoveryInterval) {
            this.networkRecoveryInterval = networkRecoveryInterval;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setAutomaticRecovery(boolean automaticRecovery) {
            this.automaticRecovery = automaticRecovery;
            return this;
        }

        public Builder setPrefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public Builder setDeliveryTimeout(long deliveryTimeout) {
            Preconditions.checkArgument((deliveryTimeout > 0L ? 1 : 0) != 0, (Object)"deliveryTimeout must be positive");
            this.deliveryTimeout = deliveryTimeout;
            return this;
        }

        public Builder setDeliveryTimeout(long deliveryTimeout, TimeUnit unit) {
            return this.setDeliveryTimeout(unit.toMillis(deliveryTimeout));
        }

        public RMQConnectionConfig build() {
            if (this.uri != null) {
                return new RMQConnectionConfig(this.uri, this.networkRecoveryInterval, this.automaticRecovery, this.topologyRecovery, this.connectionTimeout, this.requestedChannelMax, this.requestedFrameMax, this.requestedHeartbeat, this.prefetchCount, this.deliveryTimeout);
            }
            return new RMQConnectionConfig(this.host, this.port, this.virtualHost, this.username, this.password, this.networkRecoveryInterval, this.automaticRecovery, this.topologyRecovery, this.connectionTimeout, this.requestedChannelMax, this.requestedFrameMax, this.requestedHeartbeat, this.prefetchCount, this.deliveryTimeout);
        }
    }
}

