/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.AMQP;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Envelope;
import org.apache.flink.streaming.connectors.rabbitmq.RMQDeserializationSchema;

final class RMQDeserializationSchemaWrapper<OUT>
implements RMQDeserializationSchema<OUT> {
    private final DeserializationSchema<OUT> schema;

    RMQDeserializationSchemaWrapper(DeserializationSchema<OUT> deserializationSchema) {
        this.schema = deserializationSchema;
    }

    @Override
    public void deserialize(Envelope envelope, AMQP.BasicProperties properties, byte[] body, RMQDeserializationSchema.RMQCollector<OUT> collector) throws IOException {
        collector.collect(this.schema.deserialize(body));
    }

    public TypeInformation<OUT> getProducedType() {
        return this.schema.getProducedType();
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.schema.open(context);
    }

    @Override
    public boolean isEndOfStream(OUT nextElement) {
        return this.schema.isEndOfStream(nextElement);
    }
}

