/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.Address;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.ConnectionFactory;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.SslContextFactory;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.AbstractFrameHandlerFactory;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.FrameHandler;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.TlsUtils;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio.NioLoopContext;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio.NioParams;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio.SocketChannelFrameHandler;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerState;
import org.apache.flink.rabbitmq.shaded.com.rabbitmq.client.impl.nio.SslEngineHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelFrameHandler.class);
    final NioParams nioParams;
    private final SslContextFactory sslContextFactory;
    private final Lock stateLock = new ReentrantLock();
    private final AtomicLong globalConnectionCount = new AtomicLong();
    private final List<NioLoopContext> nioLoopContexts;

    public SocketChannelFrameHandlerFactory(int connectionTimeout, NioParams nioParams, boolean ssl, SslContextFactory sslContextFactory) throws IOException {
        super(connectionTimeout, null, ssl);
        this.nioParams = new NioParams(nioParams);
        this.sslContextFactory = sslContextFactory;
        this.nioLoopContexts = new ArrayList<NioLoopContext>(this.nioParams.getNbIoThreads());
        for (int i = 0; i < this.nioParams.getNbIoThreads(); ++i) {
            this.nioLoopContexts.add(new NioLoopContext(this, this.nioParams));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameHandler create(Address addr, String connectionName) throws IOException {
        int portNumber = ConnectionFactory.portOrDefault(addr.getPort(), this.ssl);
        SSLEngine sslEngine = null;
        AbstractInterruptibleChannel channel = null;
        if (this.ssl) {
            SSLContext sslContext = this.sslContextFactory.create(connectionName);
            sslEngine = sslContext.createSSLEngine(addr.getHost(), portNumber);
            sslEngine.setUseClientMode(true);
            if (this.nioParams.getSslEngineConfigurator() != null) {
                this.nioParams.getSslEngineConfigurator().configure(sslEngine);
            }
        }
        InetSocketAddress address = new InetSocketAddress(addr.getHost(), portNumber);
        channel = SocketChannel.open();
        ((AbstractSelectableChannel)channel).configureBlocking(true);
        if (this.nioParams.getSocketChannelConfigurator() != null) {
            this.nioParams.getSocketChannelConfigurator().configure((SocketChannel)channel);
        }
        ((SocketChannel)channel).connect(address);
        if (this.ssl) {
            sslEngine.beginHandshake();
            try {
                boolean handshake = SslEngineHelper.doHandshake((SocketChannel)channel, sslEngine);
                if (!handshake) {
                    LOGGER.error("TLS connection failed");
                    throw new SSLException("TLS handshake failed");
                }
            }
            catch (SSLHandshakeException e) {
                LOGGER.error("TLS connection failed: {}", (Object)e.getMessage());
                throw e;
            }
            TlsUtils.logPeerCertificateInfo(sslEngine.getSession());
        }
        ((AbstractSelectableChannel)channel).configureBlocking(false);
        this.stateLock.lock();
        NioLoopContext nioLoopContext = null;
        try {
            SocketChannelFrameHandler frameHandler;
            long modulo = this.globalConnectionCount.getAndIncrement() % (long)this.nioParams.getNbIoThreads();
            nioLoopContext = this.nioLoopContexts.get((int)modulo);
            nioLoopContext.initStateIfNecessary();
            SocketChannelFrameHandlerState state = new SocketChannelFrameHandlerState((SocketChannel)channel, nioLoopContext, this.nioParams, sslEngine);
            state.startReading();
            SocketChannelFrameHandler socketChannelFrameHandler = frameHandler = new SocketChannelFrameHandler(state);
            this.stateLock.unlock();
            return socketChannelFrameHandler;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.unlock();
                throw throwable;
            }
            catch (IOException e) {
                try {
                    if (sslEngine != null && channel != null) {
                        SslEngineHelper.close((WritableByteChannel)((Object)channel), sslEngine);
                    }
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    void lock() {
        this.stateLock.lock();
    }

    void unlock() {
        this.stateLock.unlock();
    }
}

