/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.time.Conversions;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

class PostgresEventMetadataProvider
implements EventMetadataProvider {
    PostgresEventMetadataProvider() {
    }

    @Override
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        if (sourceInfo.schema().field("ts_usec") != null) {
            Long timestamp = sourceInfo.getInt64("ts_usec");
            return timestamp == null ? null : Conversions.toInstantFromMicros(timestamp);
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    @Override
    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long xmin = sourceInfo.getInt64("xmin");
        Long lsn = sourceInfo.getInt64("lsn");
        if (lsn == null) {
            return null;
        }
        Map<String, String> r = Collect.hashMapOf("lsn", Long.toString(lsn));
        if (xmin != null) {
            r.put("xmin", Long.toString(xmin));
        }
        return r;
    }

    @Override
    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long txId = sourceInfo.getInt64("txId");
        if (txId == null) {
            return null;
        }
        return Long.toString(txId);
    }
}

