/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.configuration.description;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.description.BlockElement;
import org.apache.flink.cdc.common.configuration.description.InlineElement;
import org.apache.flink.cdc.common.configuration.description.LineBreakElement;
import org.apache.flink.cdc.common.configuration.description.ListElement;
import org.apache.flink.cdc.common.configuration.description.TextElement;

@PublicEvolving
public class Description {
    private final List<BlockElement> blocks;

    public static DescriptionBuilder builder() {
        return new DescriptionBuilder();
    }

    public List<BlockElement> getBlocks() {
        return this.blocks;
    }

    private Description(List<BlockElement> blocks) {
        this.blocks = blocks;
    }

    @PublicEvolving
    public static class DescriptionBuilder {
        private final List<BlockElement> blocks = new ArrayList<BlockElement>();

        public DescriptionBuilder text(String format, InlineElement ... elements) {
            this.blocks.add(TextElement.text(format, elements));
            return this;
        }

        public DescriptionBuilder text(String text) {
            this.blocks.add(TextElement.text(text));
            return this;
        }

        public DescriptionBuilder add(BlockElement block) {
            this.blocks.add(block);
            return this;
        }

        public DescriptionBuilder linebreak() {
            this.blocks.add(LineBreakElement.linebreak());
            return this;
        }

        public DescriptionBuilder list(InlineElement ... elements) {
            this.blocks.add(ListElement.list(elements));
            return this;
        }

        public Description build() {
            return new Description(this.blocks);
        }
    }
}

