/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.connectors.mysql.MySqlValidator;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSourceBuilder;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlBinlogSplitAssigner;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlHybridSplitAssigner;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.HybridPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsStateSerializer;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.source.enumerator.MySqlSourceEnumerator;
import org.apache.flink.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlRecordEmitter;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlSourceReader;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlSourceReaderContext;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlSplitReader;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitState;
import org.apache.flink.cdc.connectors.mysql.source.split.SourceRecords;
import org.apache.flink.cdc.connectors.mysql.source.utils.hooks.SnapshotPhaseHooks;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class MySqlSource<T>
implements Source<T, MySqlSplit, PendingSplitsState>,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 1L;
    private static final String ENUMERATOR_SERVER_NAME = "mysql_source_split_enumerator";
    private final MySqlSourceConfigFactory configFactory;
    private final DebeziumDeserializationSchema<T> deserializationSchema;
    private final RecordEmitterSupplier<T> recordEmitterSupplier;
    private SnapshotPhaseHooks snapshotHooks = SnapshotPhaseHooks.empty();

    @PublicEvolving
    public static <T> MySqlSourceBuilder<T> builder() {
        return new MySqlSourceBuilder();
    }

    MySqlSource(MySqlSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema) {
        this(configFactory, deserializationSchema, (sourceReaderMetrics, sourceConfig) -> new MySqlRecordEmitter(deserializationSchema, sourceReaderMetrics, sourceConfig.isIncludeSchemaChanges()));
    }

    MySqlSource(MySqlSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, RecordEmitterSupplier<T> recordEmitterSupplier) {
        this.configFactory = configFactory;
        this.deserializationSchema = deserializationSchema;
        this.recordEmitterSupplier = recordEmitterSupplier;
    }

    public MySqlSourceConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public Boundedness getBoundedness() {
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(0);
        if (sourceConfig.getStartupOptions().isSnapshotOnly()) {
            return Boundedness.BOUNDED;
        }
        return Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SourceReader<T, MySqlSplit> createReader(SourceReaderContext readerContext) throws Exception {
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(readerContext.getIndexOfSubtask());
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        Method metricGroupMethod = readerContext.getClass().getMethod("metricGroup", new Class[0]);
        metricGroupMethod.setAccessible(true);
        MetricGroup metricGroup = (MetricGroup)metricGroupMethod.invoke((Object)readerContext, new Object[0]);
        MySqlSourceReaderMetrics sourceReaderMetrics = new MySqlSourceReaderMetrics(metricGroup);
        sourceReaderMetrics.registerMetrics();
        MySqlSourceReaderContext mySqlSourceReaderContext = new MySqlSourceReaderContext(readerContext);
        Supplier<MySqlSplitReader> splitReaderSupplier = () -> new MySqlSplitReader(sourceConfig, readerContext.getIndexOfSubtask(), mySqlSourceReaderContext, this.snapshotHooks);
        return new MySqlSourceReader<T>((FutureCompletingBlockingQueue<RecordsWithSplitIds<SourceRecords>>)elementsQueue, splitReaderSupplier, this.recordEmitterSupplier.get(sourceReaderMetrics, sourceConfig), readerContext.getConfiguration(), mySqlSourceReaderContext, sourceConfig);
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> createEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext) {
        MySqlSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig;
        block15: {
            sourceConfig = this.configFactory.createConfig(0, ENUMERATOR_SERVER_NAME);
            MySqlValidator validator = new MySqlValidator(sourceConfig);
            validator.validate();
            if (!sourceConfig.getStartupOptions().isStreamOnly()) {
                try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(sourceConfig);){
                    boolean isTableIdCaseSensitive = DebeziumUtils.isTableIdCaseSensitive(jdbc);
                    splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), new ArrayList<TableId>(), isTableIdCaseSensitive, enumContext);
                    break block15;
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Failed to discover captured tables for enumerator", (Throwable)e);
                }
            }
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, splitAssigner, this.getBoundedness());
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> restoreEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext, PendingSplitsState checkpoint) {
        MySqlSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(0, ENUMERATOR_SERVER_NAME);
        if (checkpoint instanceof HybridPendingSplitsState) {
            splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), (HybridPendingSplitsState)checkpoint, enumContext);
        } else if (checkpoint instanceof BinlogPendingSplitsState) {
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig, (BinlogPendingSplitsState)checkpoint);
        } else {
            throw new UnsupportedOperationException("Unsupported restored PendingSplitsState: " + checkpoint);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, splitAssigner, this.getBoundedness());
    }

    public SimpleVersionedSerializer<MySqlSplit> getSplitSerializer() {
        return MySqlSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<PendingSplitsState> getEnumeratorCheckpointSerializer() {
        return new PendingSplitsStateSerializer(this.getSplitSerializer());
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }

    @VisibleForTesting
    public void setSnapshotHooks(SnapshotPhaseHooks snapshotHooks) {
        this.snapshotHooks = snapshotHooks;
    }

    @FunctionalInterface
    @Internal
    static interface RecordEmitterSupplier<T>
    extends Serializable {
        public RecordEmitter<SourceRecords, T, MySqlSplitState> get(MySqlSourceReaderMetrics var1, MySqlSourceConfig var2);
    }
}

