/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.org.bson.codecs.pojo;

import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.EnumCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecConfigurationException;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;
import org.apache.flink.mongodb.shaded.org.bson.codecs.pojo.PropertyCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.pojo.PropertyCodecRegistry;
import org.apache.flink.mongodb.shaded.org.bson.codecs.pojo.TypeWithTypeParameters;

final class EnumPropertyCodecProvider
implements PropertyCodecProvider {
    private final CodecRegistry codecRegistry;

    EnumPropertyCodecProvider(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type, PropertyCodecRegistry propertyCodecRegistry) {
        Class<T> clazz = type.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return this.codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException e) {
                return new EnumCodec<T>(clazz);
            }
        }
        return null;
    }
}

