/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.org.bson.codecs;

import java.util.UUID;
import org.apache.flink.mongodb.shaded.org.bson.BsonReader;
import org.apache.flink.mongodb.shaded.org.bson.BsonType;
import org.apache.flink.mongodb.shaded.org.bson.Transformer;
import org.apache.flink.mongodb.shaded.org.bson.UuidRepresentation;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonTypeCodecMap;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DecoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;

final class ContainerCodecHelper {
    static Object readValue(BsonReader reader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry registry, Transformer valueTransformer) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<Object> codec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY && reader.peekBinarySize() == 16) {
            switch (reader.peekBinarySubType()) {
                case 3: {
                    if (uuidRepresentation != UuidRepresentation.JAVA_LEGACY && uuidRepresentation != UuidRepresentation.C_SHARP_LEGACY && uuidRepresentation != UuidRepresentation.PYTHON_LEGACY) break;
                    codec = registry.get(UUID.class);
                    break;
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    codec = registry.get(UUID.class);
                    break;
                }
            }
        }
        return valueTransformer.transform(codec.decode(reader, decoderContext));
    }

    private ContainerCodecHelper() {
    }
}

