/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.management;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCheckedInEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCheckedOutEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionClosedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCreatedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionPoolCreatedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionPoolListener;
import org.apache.flink.mongodb.shaded.com.mongodb.management.ConnectionPoolStatisticsMBean;

final class ConnectionPoolStatistics
implements ConnectionPoolListener,
ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();

    ConnectionPoolStatistics(ConnectionPoolCreatedEvent event) {
        this.serverAddress = event.getServerId().getAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent event) {
        this.size.decrementAndGet();
    }
}

