/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.selector;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerConnectionState;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.selector.ReadPreferenceServerSelector;
import org.apache.flink.mongodb.shaded.com.mongodb.selector.ServerSelector;

public class ReadPreferenceWithFallbackServerSelector
implements ServerSelector {
    private final ReadPreference preferredReadPreference;
    private final int minWireVersion;
    private final ReadPreference fallbackReadPreference;
    private ReadPreference appliedReadPreference;

    public ReadPreferenceWithFallbackServerSelector(ReadPreference preferredReadPreference, int minWireVersion, ReadPreference fallbackReadPreference) {
        this.preferredReadPreference = preferredReadPreference;
        this.minWireVersion = minWireVersion;
        this.fallbackReadPreference = fallbackReadPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (this.clusterContainsOlderServers(clusterDescription)) {
            this.appliedReadPreference = this.fallbackReadPreference;
            return new ReadPreferenceServerSelector(this.fallbackReadPreference).select(clusterDescription);
        }
        this.appliedReadPreference = this.preferredReadPreference;
        return new ReadPreferenceServerSelector(this.preferredReadPreference).select(clusterDescription);
    }

    public ReadPreference getAppliedReadPreference() {
        return this.appliedReadPreference;
    }

    private boolean clusterContainsOlderServers(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().filter(serverDescription -> serverDescription.getState() == ServerConnectionState.CONNECTED).anyMatch(serverDescription -> serverDescription.getMaxWireVersion() < this.minWireVersion);
    }
}

