/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.InsertRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.WriteRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.BaseWriteOperation;

public class InsertOperation
extends BaseWriteOperation {
    private final List<InsertRequest> insertRequests;

    public InsertOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> insertRequests) {
        this(namespace, ordered, writeConcern, false, insertRequests);
    }

    public InsertOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<InsertRequest> insertRequests) {
        super(namespace, ordered, writeConcern, retryWrites);
        this.insertRequests = Assertions.notNull("insertRequests", insertRequests);
        Assertions.isTrueArgument("insertRequests not empty", !insertRequests.isEmpty());
    }

    public List<InsertRequest> getInsertRequests() {
        return this.insertRequests;
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.INSERT;
    }

    @Override
    protected List<? extends WriteRequest> getWriteRequests() {
        return this.getInsertRequests();
    }
}

