/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.flink.mongodb.shaded.com.mongodb.CursorType;
import org.apache.flink.mongodb.shaded.com.mongodb.ExplainVerbosity;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoQueryException;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Collation;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerType;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.AsyncBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.AsyncCallbackSupplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.RetryState;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsyncConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.NoOpSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.QueryResult;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AggregateResponseBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncExplainableReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncQueryBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.BatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandOperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandResultDocumentCodec;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.DocumentHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ExplainHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ExplainableReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationReadConcernHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.QueryBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ServerVersionHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

public class FindOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private int limit;
    private BsonDocument projection;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private BsonDocument sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean secondaryOk;
    private boolean oplogReplay;
    private boolean noCursorTimeout;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private BsonDocument max;
    private BsonDocument min;
    private boolean returnKey;
    private boolean showRecordId;
    private Boolean allowDiskUse;

    public FindOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOperation<T> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOperation<T> cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public boolean isSecondaryOk() {
        return this.secondaryOk;
    }

    public FindOperation<T> secondaryOk(boolean secondaryOk) {
        this.secondaryOk = secondaryOk;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public FindOperation<T> oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOperation<T> noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOperation<T> partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public FindOperation<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public FindOperation<T> hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public FindOperation<T> let(BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public BsonDocument getMax() {
        return this.max;
    }

    public FindOperation<T> max(BsonDocument max) {
        this.max = max;
        return this;
    }

    public BsonDocument getMin() {
        return this.min;
    }

    public FindOperation<T> min(BsonDocument min) {
        this.min = min;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOperation<T> returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOperation<T> showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public FindOperation<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        Supplier<BatchCursor> read = CommandOperationHelper.decorateReadWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            return OperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
                retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()));
                if (ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                    try {
                        return CommandOperationHelper.createReadCommandAndExecute(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.transformer(), connection);
                    }
                    catch (MongoCommandException e) {
                        throw new MongoQueryException(e);
                    }
                }
                retryState.markAsLastAttempt();
                OperationHelper.validateFindOptions(connection, binding.getSessionContext().getReadConcern(), this.collation, this.allowDiskUse);
                QueryResult<T> queryResult = connection.query(this.namespace, this.asDocument(connection.getDescription(), binding.getReadPreference()), this.projection, this.skip, this.limit, this.batchSize, this.isSecondaryOk() || binding.getReadPreference().isSecondaryOk(), this.isTailableCursor(), this.isAwaitData(), this.isNoCursorTimeout(), this.isPartial(), this.isOplogReplay(), this.decoder, binding.getRequestContext());
                return new QueryBatchCursor<T>(queryResult, this.limit, this.batchSize, this.getMaxTimeForCursor(), this.decoder, this.comment, (ConnectionSource)source, (Connection)connection);
            });
        });
        return read.get();
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = CommandOperationHelper.decorateReadWithRetries(retryState, funcCallback -> {
            CommandOperationHelper.logRetryExecute(retryState);
            OperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()), releasingCallback)) {
                    return;
                }
                if (ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                    SingleResultCallback<T> wrappedCallback = FindOperation.exceptionTransformingCallback(releasingCallback);
                    CommandOperationHelper.createReadCommandAndExecuteAsync(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.asyncTransformer(), connection, wrappedCallback);
                } else {
                    retryState.markAsLastAttempt();
                    OperationHelper.validateFindOptions(source, connection, binding.getSessionContext().getReadConcern(), this.collation, this.allowDiskUse, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(final AsyncConnectionSource source, final AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                releasingCallback.onResult(null, t);
                            } else {
                                connection.queryAsync(FindOperation.this.namespace, FindOperation.this.asDocument(connection.getDescription(), binding.getReadPreference()), FindOperation.this.projection, FindOperation.this.skip, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.isSecondaryOk() || binding.getReadPreference().isSecondaryOk(), FindOperation.this.isTailableCursor(), FindOperation.this.isAwaitData(), FindOperation.this.isNoCursorTimeout(), FindOperation.this.isPartial(), FindOperation.this.isOplogReplay(), FindOperation.this.decoder, binding.getRequestContext(), new SingleResultCallback<QueryResult<T>>(){

                                    @Override
                                    public void onResult(QueryResult<T> result, Throwable t) {
                                        if (t != null) {
                                            releasingCallback.onResult(null, t);
                                        } else {
                                            releasingCallback.onResult(new AsyncQueryBatchCursor(result, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, FindOperation.this.comment, source, connection), null);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private static <T> SingleResultCallback<T> exceptionTransformingCallback(final SingleResultCallback<T> callback) {
        return new SingleResultCallback<T>(){

            @Override
            public void onResult(T result, Throwable t) {
                if (t != null) {
                    if (t instanceof MongoCommandException) {
                        MongoCommandException commandException = (MongoCommandException)t;
                        callback.onResult(result, new MongoQueryException(commandException.getServerAddress(), commandException.getErrorCode(), commandException.getErrorMessage()));
                    } else {
                        callback.onResult(result, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }
        };
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(NoOpSessionContext.INSTANCE, 0), verbosity), resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(NoOpSessionContext.INSTANCE, 0), verbosity), resultDecoder);
    }

    private BsonDocument asDocument(ConnectionDescription connectionDescription, ReadPreference readPreference) {
        BsonDocument document = new BsonDocument();
        if (this.sort != null) {
            document.put("$orderby", this.sort);
        }
        if (this.maxTimeMS > 0L) {
            document.put("$maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (connectionDescription.getServerType() == ServerType.SHARD_ROUTER && !readPreference.equals(ReadPreference.primary())) {
            document.put("$readPreference", readPreference.toDocument());
        }
        if (this.comment != null) {
            document.put("$comment", this.comment);
        }
        if (this.hint != null) {
            document.put("$hint", this.hint);
        }
        if (this.max != null) {
            document.put("$max", this.max);
        }
        if (this.min != null) {
            document.put("$min", this.min);
        }
        if (this.returnKey) {
            document.put("$returnKey", BsonBoolean.TRUE);
        }
        if (this.showRecordId) {
            document.put("$showDiskLoc", BsonBoolean.TRUE);
        }
        if (document.isEmpty()) {
            document = this.filter != null ? this.filter : new BsonDocument();
        } else if (this.filter != null) {
            document.put("$query", this.filter);
        } else if (!document.containsKey("$query")) {
            document.put("$query", new BsonDocument());
        }
        return document;
    }

    private BsonDocument getCommand(SessionContext sessionContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument("find", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, maxWireVersion, commandDocument);
        DocumentHelper.putIfNotNull(commandDocument, "filter", this.filter);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "sort", this.sort);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "projection", this.projection);
        if (this.skip > 0) {
            commandDocument.put("skip", new BsonInt32(this.skip));
        }
        if (this.limit != 0) {
            commandDocument.put("limit", new BsonInt32(Math.abs(this.limit)));
        }
        if (this.limit >= 0) {
            if (this.batchSize < 0 && Math.abs(this.batchSize) < this.limit) {
                commandDocument.put("limit", new BsonInt32(Math.abs(this.batchSize)));
            } else if (this.batchSize != 0) {
                commandDocument.put("batchSize", new BsonInt32(Math.abs(this.batchSize)));
            }
        }
        if (this.limit < 0 || this.batchSize < 0) {
            commandDocument.put("singleBatch", BsonBoolean.TRUE);
        }
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (this.isTailableCursor()) {
            commandDocument.put("tailable", BsonBoolean.TRUE);
        }
        if (this.isAwaitData()) {
            commandDocument.put("awaitData", BsonBoolean.TRUE);
        }
        if (this.oplogReplay) {
            commandDocument.put("oplogReplay", BsonBoolean.TRUE);
        }
        if (this.noCursorTimeout) {
            commandDocument.put("noCursorTimeout", BsonBoolean.TRUE);
        }
        if (this.partial) {
            commandDocument.put("allowPartialResults", BsonBoolean.TRUE);
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        if (this.max != null) {
            commandDocument.put("max", this.max);
        }
        if (this.min != null) {
            commandDocument.put("min", this.min);
        }
        if (this.returnKey) {
            commandDocument.put("returnKey", BsonBoolean.TRUE);
        }
        if (this.showRecordId) {
            commandDocument.put("showRecordId", BsonBoolean.TRUE);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        return commandDocument;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateFindOptions(connectionDescription, sessionContext.getReadConcern(), FindOperation.this.collation, FindOperation.this.allowDiskUse);
                return FindOperation.this.getCommand(sessionContext, connectionDescription.getMaxWireVersion());
            }
        };
    }

    private boolean isTailableCursor() {
        return this.cursorType.isTailable();
    }

    private boolean isAwaitData() {
        return this.cursorType == CursorType.TailableAwait;
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, AggregateResponseBatchCursor<T>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, AggregateResponseBatchCursor<T>>(){

            @Override
            public AggregateResponseBatchCursor<T> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                QueryResult queryResult = OperationHelper.cursorDocumentToQueryResult(result.getDocument("cursor"), connection.getDescription().getServerAddress());
                return new QueryBatchCursor(queryResult, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, FindOperation.this.comment, source, connection, result);
            }
        };
    }

    private long getMaxTimeForCursor() {
        return this.cursorType == CursorType.TailableAwait ? this.maxAwaitTimeMS : 0L;
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                QueryResult queryResult = OperationHelper.cursorDocumentToQueryResult(result.getDocument("cursor"), connection.getDescription().getServerAddress());
                return new AsyncQueryBatchCursor(queryResult, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, FindOperation.this.comment, source, connection, result);
            }
        };
    }
}

