/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.DeleteRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.WriteRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.BaseWriteOperation;

public class DeleteOperation
extends BaseWriteOperation {
    private final List<DeleteRequest> deleteRequests;

    public DeleteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deleteRequests) {
        this(namespace, ordered, writeConcern, false, deleteRequests);
    }

    public DeleteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<DeleteRequest> deleteRequests) {
        super(namespace, ordered, writeConcern, retryWrites);
        this.deleteRequests = Assertions.notNull("removes", deleteRequests);
        Assertions.isTrueArgument("deleteRequests not empty", !deleteRequests.isEmpty());
    }

    public List<DeleteRequest> getDeleteRequests() {
        return this.deleteRequests;
    }

    @Override
    protected List<? extends WriteRequest> getWriteRequests() {
        return this.getDeleteRequests();
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.DELETE;
    }
}

