/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandResultDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonArrayCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonBinaryCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonBooleanCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDBPointerCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDateTimeCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDecimal128Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDoubleCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonInt32Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonInt64Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonJavaScriptCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonJavaScriptWithScopeCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonMaxKeyCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonMinKeyCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonNullCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonObjectIdCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonRegularExpressionCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonStringCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonSymbolCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonTimestampCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonUndefinedCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

