/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.AsyncBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ChangeStreamBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ChangeStreamOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.NonNull;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonTimestamp;
import org.apache.flink.mongodb.shaded.org.bson.RawBsonDocument;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private final AtomicReference<AsyncAggregateResponseBatchCursor<RawBsonDocument>> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncAggregateResponseBatchCursor<RawBsonDocument> wrapped, AsyncReadBinding binding, BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = new AtomicReference<AsyncAggregateResponseBatchCursor<RawBsonDocument>>(Assertions.assertNotNull(wrapped));
        this.binding = binding;
        binding.retain();
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.isClosed = new AtomicBoolean();
    }

    @NonNull
    AsyncAggregateResponseBatchCursor<RawBsonDocument> getWrapped() {
        return Assertions.assertNotNull(this.wrapped.get());
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(new AsyncBlock(){

            @Override
            public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> cursor, SingleResultCallback<List<RawBsonDocument>> callback) {
                cursor.next(callback);
            }
        }, callback, false);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.nullifyAndCloseWrapped();
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.getWrapped().setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.getWrapped().getBatchSize();
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed.get()) {
            return true;
        }
        if (this.wrappedClosedItself()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean wrappedClosedItself() {
        AsyncAggregateResponseBatchCursor<RawBsonDocument> observedWrapped = this.wrapped.get();
        return observedWrapped != null && observedWrapped.isClosed();
    }

    private void nullifyAndCloseWrapped() {
        AsyncAggregateResponseBatchCursor observedWrapped = this.wrapped.getAndSet(null);
        if (observedWrapped != null) {
            observedWrapped.close();
        }
    }

    private void setWrappedOrCloseIt(AsyncAggregateResponseBatchCursor<RawBsonDocument> newValue) {
        if (this.isClosed()) {
            Assertions.assertNull(this.wrapped.get());
            newValue.close();
        } else {
            Assertions.assertNull(this.wrapped.getAndSet(newValue));
            if (this.isClosed()) {
                this.nullifyAndCloseWrapped();
            }
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.getWrapped().getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.getWrapped().isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncAggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
        BsonDocument resumeToken = queryBatchCursor.getPostBatchResumeToken();
        if (resumeToken != null) {
            this.resumeToken = resumeToken;
        }
    }

    private void resumeableOperation(final AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, final boolean tryNext) {
        final SingleResultCallback<List<Object>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        if (this.isClosed()) {
            errHandlingCallback.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", tryNext ? "tryNext()" : "next()")));
            return;
        }
        final AsyncAggregateResponseBatchCursor<RawBsonDocument> wrappedCursor = this.getWrapped();
        asyncBlock.apply(wrappedCursor, new SingleResultCallback<List<RawBsonDocument>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<RawBsonDocument> result, Throwable t) {
                if (t == null) {
                    try {
                        List convertedResults;
                        try {
                            convertedResults = ChangeStreamBatchCursor.convertAndProduceLastId(result, AsyncChangeStreamBatchCursor.this.changeStreamOperation.getDecoder(), lastId -> AsyncChangeStreamBatchCursor.this.resumeToken = lastId);
                        }
                        finally {
                            AsyncChangeStreamBatchCursor.this.cachePostBatchResumeToken(wrappedCursor);
                        }
                        errHandlingCallback.onResult(convertedResults, null);
                    }
                    catch (Exception e) {
                        errHandlingCallback.onResult(null, e);
                    }
                } else {
                    AsyncChangeStreamBatchCursor.this.cachePostBatchResumeToken(wrappedCursor);
                    if (ChangeStreamBatchCursorHelper.isResumableError(t, AsyncChangeStreamBatchCursor.this.maxWireVersion)) {
                        AsyncChangeStreamBatchCursor.this.nullifyAndCloseWrapped();
                        AsyncChangeStreamBatchCursor.this.retryOperation(asyncBlock, errHandlingCallback, tryNext);
                    } else {
                        errHandlingCallback.onResult(null, t);
                    }
                }
            }
        });
    }

    private void retryOperation(final AsyncBlock asyncBlock, final SingleResultCallback<List<T>> callback, final boolean tryNext) {
        OperationHelper.withAsyncReadConnection(this.binding, new OperationHelper.AsyncCallableWithSource(){

            @Override
            public void call(AsyncConnectionSource source, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    AsyncChangeStreamBatchCursor.this.changeStreamOperation.setChangeStreamOptionsForResume(AsyncChangeStreamBatchCursor.this.resumeToken, source.getServerDescription().getMaxWireVersion());
                    source.release();
                    AsyncChangeStreamBatchCursor.this.changeStreamOperation.executeAsync(AsyncChangeStreamBatchCursor.this.binding, new SingleResultCallback<AsyncBatchCursor<T>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResult(AsyncBatchCursor<T> result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                try {
                                    AsyncChangeStreamBatchCursor.this.setWrappedOrCloseIt(((AsyncChangeStreamBatchCursor)result).getWrapped());
                                }
                                finally {
                                    try {
                                        AsyncChangeStreamBatchCursor.this.binding.release();
                                    }
                                    finally {
                                        AsyncChangeStreamBatchCursor.this.resumeableOperation(asyncBlock, callback, tryNext);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

