/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.inject;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.inject.Provider;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

@ThreadSafe
public final class SameObjectProvider<T>
implements Provider<T> {
    private final AtomicReference<T> object = new AtomicReference();

    private SameObjectProvider(@Nullable T o) {
        if (o != null) {
            this.initialize(o);
        }
    }

    @Override
    public T get() {
        return Assertions.assertNotNull(this.object.get());
    }

    @Override
    public Optional<T> optional() {
        return Optional.of(this.get());
    }

    public void initialize(T o) {
        Assertions.assertTrue(this.object.compareAndSet(null, o));
    }

    public static <T> SameObjectProvider<T> initialized(T o) {
        return new SameObjectProvider<T>(o);
    }

    public static <T> SameObjectProvider<T> uninitialized() {
        return new SameObjectProvider<Object>(null);
    }
}

