/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandFailedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandStartedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandSucceededEvent;

final class CommandListenerMulticaster
implements CommandListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<CommandListener> commandListeners;

    CommandListenerMulticaster(List<CommandListener> commandListeners) {
        Assertions.isTrue("All CommandListener instances are non-null", !commandListeners.contains(null));
        this.commandListeners = new ArrayList<CommandListener>(commandListeners);
    }

    @Override
    public void commandStarted(CommandStartedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandFailed(CommandFailedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", cur), e);
            }
        }
    }
}

