/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.dns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoConfigurationException;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.dns.DnsResolver;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.dns.JndiDnsClient;
import org.apache.flink.mongodb.shaded.com.mongodb.spi.dns.DnsClient;
import org.apache.flink.mongodb.shaded.com.mongodb.spi.dns.DnsClientProvider;
import org.apache.flink.mongodb.shaded.com.mongodb.spi.dns.DnsWithResponseCodeException;

public final class DefaultDnsResolver
implements DnsResolver {
    private final DnsClient dnsClient;

    public DefaultDnsResolver() {
        ServiceLoader<DnsClientProvider> loader = ServiceLoader.load(DnsClientProvider.class);
        DnsClient dnsClientFromServiceLoader = null;
        Iterator<DnsClientProvider> iterator = loader.iterator();
        if (iterator.hasNext()) {
            DnsClientProvider dnsClientProvider = iterator.next();
            dnsClientFromServiceLoader = dnsClientProvider.create();
        }
        this.dnsClient = dnsClientFromServiceLoader == null ? new JndiDnsClient() : dnsClientFromServiceLoader;
    }

    @Override
    public List<String> resolveHostFromSrvRecords(String srvHost, String srvServiceName) {
        String srvHostDomain = srvHost.substring(srvHost.indexOf(46) + 1);
        List<String> srvHostDomainParts = Arrays.asList(srvHostDomain.split("\\."));
        ArrayList<String> hosts = new ArrayList<String>();
        String resourceName = "_" + srvServiceName + "._tcp." + srvHost;
        try {
            List<String> srvAttributeValues = this.dnsClient.getResourceRecordData(resourceName, "SRV");
            if (srvAttributeValues == null || srvAttributeValues.isEmpty()) {
                throw new MongoConfigurationException(String.format("No SRV records available for '%s'.", resourceName));
            }
            for (String srvRecord : srvAttributeValues) {
                String[] split = srvRecord.split(" ");
                String resolvedHost = split[3].endsWith(".") ? split[3].substring(0, split[3].length() - 1) : split[3];
                String resolvedHostDomain = resolvedHost.substring(resolvedHost.indexOf(46) + 1);
                if (!DefaultDnsResolver.sameParentDomain(srvHostDomainParts, resolvedHostDomain)) {
                    throw new MongoConfigurationException(String.format("The SRV host name '%s' resolved to a host '%s 'that is not in a sub-domain of the SRV host.", srvHost, resolvedHost));
                }
                hosts.add(resolvedHost + ":" + split[2]);
            }
        }
        catch (Exception e) {
            throw new MongoConfigurationException(String.format("Failed looking up SRV record for '%s'.", resourceName), e);
        }
        return hosts;
    }

    private static boolean sameParentDomain(List<String> srvHostDomainParts, String resolvedHostDomain) {
        List<String> resolvedHostDomainParts = Arrays.asList(resolvedHostDomain.split("\\."));
        if (srvHostDomainParts.size() > resolvedHostDomainParts.size()) {
            return false;
        }
        return resolvedHostDomainParts.subList(resolvedHostDomainParts.size() - srvHostDomainParts.size(), resolvedHostDomainParts.size()).equals(srvHostDomainParts);
    }

    @Override
    public String resolveAdditionalQueryParametersFromTxtRecords(String host) {
        try {
            List<String> attributeValues = this.dnsClient.getResourceRecordData(host, "TXT");
            if (attributeValues == null || attributeValues.isEmpty()) {
                return "";
            }
            if (attributeValues.size() > 1) {
                throw new MongoConfigurationException(String.format("Multiple TXT records found for host '%s'.  Only one is permitted", host));
            }
            return attributeValues.get(0).replaceAll("\\s", "");
        }
        catch (DnsWithResponseCodeException e) {
            if (e.getResponseCode() != 3) {
                throw new MongoConfigurationException("Failed looking up TXT record for host " + host, e);
            }
            return "";
        }
        catch (Exception e) {
            throw new MongoConfigurationException("Failed looking up TXT record for host " + host, e);
        }
    }
}

