/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.AuthenticationMechanism;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSecurityException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Authenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SpeculativeAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ServerVersionHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;

class X509Authenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private BsonDocument speculativeAuthenticateResponse;

    X509Authenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        if (this.speculativeAuthenticateResponse != null) {
            return;
        }
        try {
            this.validateUserName(connectionDescription);
            BsonDocument authCommand = this.getAuthCommand(this.getMongoCredential().getUserName());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, this.getClusterConnectionMode(), this.getServerApi(), connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        if (this.speculativeAuthenticateResponse != null) {
            callback.onResult(null, null);
        } else {
            final SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
            try {
                this.validateUserName(connectionDescription);
                CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.getAuthCommand(this.getMongoCredential().getUserName()), this.getClusterConnectionMode(), this.getServerApi(), connection, new SingleResultCallback<BsonDocument>(){

                    @Override
                    public void onResult(BsonDocument nonceResult, Throwable t) {
                        if (t != null) {
                            errHandlingCallback.onResult(null, X509Authenticator.this.translateThrowable(t));
                        } else {
                            errHandlingCallback.onResult(null, null);
                        }
                    }
                });
            }
            catch (Throwable t) {
                errHandlingCallback.onResult(null, t);
            }
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        return this.getAuthCommand(this.getMongoCredential().getUserName()).append("db", new BsonString("$external"));
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        this.speculativeAuthenticateResponse = response;
    }

    @Override
    public BsonDocument getSpeculativeAuthenticateResponse() {
        return this.speculativeAuthenticateResponse;
    }

    private BsonDocument getAuthCommand(String userName) {
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        if (userName != null) {
            cmd.put("user", new BsonString(userName));
        }
        cmd.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return cmd;
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }

    private void validateUserName(ConnectionDescription connectionDescription) {
        if (this.getMongoCredential().getUserName() == null && ServerVersionHelper.serverIsLessThanVersionThreeDotFour(connectionDescription)) {
            throw new MongoSecurityException(this.getMongoCredential(), "User name is required for the MONGODB-X509 authentication mechanism on server versions less than 3.4");
        }
    }
}

