/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Collections;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.RequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcernResult;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.UpdateRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ByteBufBsonDocument;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ByteBufferBsonOutput;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MessageSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.RequestMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.UpdateMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.WriteProtocol;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;

class UpdateProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.update");
    private final UpdateRequest updateRequest;

    UpdateProtocol(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext) {
        super(namespace, ordered, requestContext);
        this.updateRequest = updateRequest;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Update completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous update completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        List<ByteBufBsonDocument> documents = ByteBufBsonDocument.createList(bsonOutput, firstDocumentPosition);
        BsonDocument updateDocument = new BsonDocument("q", documents.get(0)).append("u", documents.get(1));
        if (this.updateRequest.isMulti()) {
            updateDocument.append("multi", BsonBoolean.TRUE);
        }
        if (this.updateRequest.isUpsert()) {
            updateDocument.append("upsert", BsonBoolean.TRUE);
        }
        return this.getBaseCommandDocument("update").append("updates", new BsonArray(Collections.singletonList(updateDocument)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new UpdateMessage(this.getNamespace().getFullName(), this.updateRequest, settings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

