/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.RequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcernResult;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.InsertRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ByteBufBsonDocument;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ByteBufferBsonOutput;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InsertMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MessageSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.RequestMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.WriteProtocol;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;

class InsertProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.insert");
    private final InsertRequest insertRequest;

    InsertProtocol(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext) {
        super(namespace, ordered, requestContext);
        this.insertRequest = insertRequest;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Inserting 1 document into namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Insert completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously inserting 1 document into namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous insert completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        return this.getBaseCommandDocument("insert").append("documents", new BsonArray(ByteBufBsonDocument.createList(bsonOutput, firstDocumentPosition)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new InsertMessage(this.getNamespace().getFullName(), this.insertRequest, settings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

