/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.InsertRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LegacyMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MessageSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.OpCode;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.RequestMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.apache.flink.mongodb.shaded.org.bson.io.BsonOutput;

class InsertMessage
extends LegacyMessage {
    private final InsertRequest insertRequest;

    InsertMessage(String collectionName, InsertRequest insertRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_INSERT, settings);
        this.insertRequest = insertRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream) {
        this.writeInsertPrologue(outputStream);
        int firstDocumentPosition = outputStream.getPosition();
        this.addCollectibleDocument(this.insertRequest.getDocument(), outputStream, new NoOpFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentPosition);
    }

    private void writeInsertPrologue(BsonOutput outputStream) {
        outputStream.writeInt32(0);
        outputStream.writeCString(this.getCollectionName());
    }
}

