/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.function.Supplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LevelCountingBsonWriter;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinary;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinaryWriter;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDateTime;
import org.apache.flink.mongodb.shaded.org.bson.BsonDbPointer;
import org.apache.flink.mongodb.shaded.org.bson.BsonDecimal128;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonDouble;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;
import org.apache.flink.mongodb.shaded.org.bson.BsonJavaScript;
import org.apache.flink.mongodb.shaded.org.bson.BsonJavaScriptWithScope;
import org.apache.flink.mongodb.shaded.org.bson.BsonMaxKey;
import org.apache.flink.mongodb.shaded.org.bson.BsonMinKey;
import org.apache.flink.mongodb.shaded.org.bson.BsonNull;
import org.apache.flink.mongodb.shaded.org.bson.BsonObjectId;
import org.apache.flink.mongodb.shaded.org.bson.BsonReader;
import org.apache.flink.mongodb.shaded.org.bson.BsonRegularExpression;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonSymbol;
import org.apache.flink.mongodb.shaded.org.bson.BsonTimestamp;
import org.apache.flink.mongodb.shaded.org.bson.BsonUndefined;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.BsonWriter;
import org.apache.flink.mongodb.shaded.org.bson.RawBsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.io.BasicOutputBuffer;
import org.apache.flink.mongodb.shaded.org.bson.types.Decimal128;
import org.apache.flink.mongodb.shaded.org.bson.types.ObjectId;

public class IdHoldingBsonWriter
extends LevelCountingBsonWriter {
    private static final String ID_FIELD_NAME = "_id";
    private LevelCountingBsonWriter idBsonBinaryWriter;
    private BasicOutputBuffer outputBuffer;
    private String currentFieldName;
    private BsonValue id;
    private boolean idFieldIsAnArray = false;

    public IdHoldingBsonWriter(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    @Override
    public void writeStartDocument(String name) {
        this.setCurrentFieldName(name);
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeStartDocument(name);
        }
        super.writeStartDocument(name);
    }

    @Override
    public void writeStartDocument() {
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeStartDocument();
        }
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() >= 0) {
                this.getIdBsonWriter().writeEndDocument();
            }
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                if (this.id != null && this.id.isJavaScriptWithScope()) {
                    this.id = new BsonJavaScriptWithScope(this.id.asJavaScriptWithScope().getCode(), new RawBsonDocument(this.getBytes()));
                } else if (this.id == null) {
                    this.id = new RawBsonDocument(this.getBytes());
                }
            }
        }
        if (this.getCurrentLevel() == 0 && this.id == null) {
            this.id = new BsonObjectId();
            this.writeObjectId(ID_FIELD_NAME, this.id.asObjectId().getValue());
        }
        super.writeEndDocument();
    }

    @Override
    public void writeStartArray() {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                this.idFieldIsAnArray = true;
                this.getIdBsonWriter().writeStartDocument();
                this.getIdBsonWriter().writeName(ID_FIELD_NAME);
            }
            this.getIdBsonWriter().writeStartArray();
        }
        super.writeStartArray();
    }

    @Override
    public void writeStartArray(String name) {
        this.setCurrentFieldName(name);
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                this.getIdBsonWriter().writeStartDocument();
            }
            this.getIdBsonWriter().writeStartArray(name);
        }
        super.writeStartArray(name);
    }

    @Override
    public void writeEndArray() {
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeEndArray();
            if (this.getIdBsonWriterCurrentLevel() == 0 && this.idFieldIsAnArray) {
                this.getIdBsonWriter().writeEndDocument();
                this.id = new RawBsonDocument(this.getBytes()).get(ID_FIELD_NAME);
            }
        }
        super.writeEndArray();
    }

    @Override
    public void writeBinaryData(String name, BsonBinary binary) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> binary, () -> this.getIdBsonWriter().writeBinaryData(name, binary));
        super.writeBinaryData(name, binary);
    }

    @Override
    public void writeBinaryData(BsonBinary binary) {
        this.addBsonValue(() -> binary, () -> this.getIdBsonWriter().writeBinaryData(binary));
        super.writeBinaryData(binary);
    }

    @Override
    public void writeBoolean(String name, boolean value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> BsonBoolean.valueOf(value), () -> this.getIdBsonWriter().writeBoolean(name, value));
        super.writeBoolean(name, value);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.addBsonValue(() -> BsonBoolean.valueOf(value), () -> this.getIdBsonWriter().writeBoolean(value));
        super.writeBoolean(value);
    }

    @Override
    public void writeDateTime(String name, long value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonDateTime(value), () -> this.getIdBsonWriter().writeDateTime(name, value));
        super.writeDateTime(name, value);
    }

    @Override
    public void writeDateTime(long value) {
        this.addBsonValue(() -> new BsonDateTime(value), () -> this.getIdBsonWriter().writeDateTime(value));
        super.writeDateTime(value);
    }

    @Override
    public void writeDBPointer(String name, BsonDbPointer value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> value, () -> this.getIdBsonWriter().writeDBPointer(name, value));
        super.writeDBPointer(name, value);
    }

    @Override
    public void writeDBPointer(BsonDbPointer value) {
        this.addBsonValue(() -> value, () -> this.getIdBsonWriter().writeDBPointer(value));
        super.writeDBPointer(value);
    }

    @Override
    public void writeDouble(String name, double value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonDouble(value), () -> this.getIdBsonWriter().writeDouble(name, value));
        super.writeDouble(name, value);
    }

    @Override
    public void writeDouble(double value) {
        this.addBsonValue(() -> new BsonDouble(value), () -> this.getIdBsonWriter().writeDouble(value));
        super.writeDouble(value);
    }

    @Override
    public void writeInt32(String name, int value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonInt32(value), () -> this.getIdBsonWriter().writeInt32(name, value));
        super.writeInt32(name, value);
    }

    @Override
    public void writeInt32(int value) {
        this.addBsonValue(() -> new BsonInt32(value), () -> this.getIdBsonWriter().writeInt32(value));
        super.writeInt32(value);
    }

    @Override
    public void writeInt64(String name, long value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonInt64(value), () -> this.getIdBsonWriter().writeInt64(name, value));
        super.writeInt64(name, value);
    }

    @Override
    public void writeInt64(long value) {
        this.addBsonValue(() -> new BsonInt64(value), () -> this.getIdBsonWriter().writeInt64(value));
        super.writeInt64(value);
    }

    @Override
    public void writeDecimal128(String name, Decimal128 value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonDecimal128(value), () -> this.getIdBsonWriter().writeDecimal128(name, value));
        super.writeDecimal128(name, value);
    }

    @Override
    public void writeDecimal128(Decimal128 value) {
        this.addBsonValue(() -> new BsonDecimal128(value), () -> this.getIdBsonWriter().writeDecimal128(value));
        super.writeDecimal128(value);
    }

    @Override
    public void writeJavaScript(String name, String code) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonJavaScript(code), () -> this.getIdBsonWriter().writeJavaScript(name, code));
        super.writeJavaScript(name, code);
    }

    @Override
    public void writeJavaScript(String code) {
        this.addBsonValue(() -> new BsonJavaScript(code), () -> this.getIdBsonWriter().writeJavaScript(code));
        super.writeJavaScript(code);
    }

    @Override
    public void writeJavaScriptWithScope(String name, String code) {
        this.addBsonValue(() -> new BsonJavaScriptWithScope(code, new BsonDocument()), () -> this.getIdBsonWriter().writeJavaScriptWithScope(name, code));
        super.writeJavaScriptWithScope(name, code);
    }

    @Override
    public void writeJavaScriptWithScope(String code) {
        this.addBsonValue(() -> new BsonJavaScriptWithScope(code, new BsonDocument()), () -> this.getIdBsonWriter().writeJavaScriptWithScope(code));
        super.writeJavaScriptWithScope(code);
    }

    @Override
    public void writeMaxKey(String name) {
        this.setCurrentFieldName(name);
        this.addBsonValue(BsonMaxKey::new, () -> this.getIdBsonWriter().writeMaxKey(name));
        super.writeMaxKey(name);
    }

    @Override
    public void writeMaxKey() {
        this.addBsonValue(BsonMaxKey::new, this.getIdBsonWriter()::writeMaxKey);
        super.writeMaxKey();
    }

    @Override
    public void writeMinKey(String name) {
        this.setCurrentFieldName(name);
        this.addBsonValue(BsonMinKey::new, () -> this.getIdBsonWriter().writeMinKey(name));
        super.writeMinKey(name);
    }

    @Override
    public void writeMinKey() {
        this.addBsonValue(BsonMinKey::new, this.getIdBsonWriter()::writeMinKey);
        super.writeMinKey();
    }

    @Override
    public void writeName(String name) {
        this.setCurrentFieldName(name);
        if (this.getIdBsonWriterCurrentLevel() >= 0) {
            this.getIdBsonWriter().writeName(name);
        }
        super.writeName(name);
    }

    @Override
    public void writeNull(String name) {
        this.setCurrentFieldName(name);
        this.addBsonValue(BsonNull::new, () -> this.getIdBsonWriter().writeNull(name));
        super.writeNull(name);
    }

    @Override
    public void writeNull() {
        this.addBsonValue(BsonNull::new, this.getIdBsonWriter()::writeNull);
        super.writeNull();
    }

    @Override
    public void writeObjectId(String name, ObjectId objectId) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonObjectId(objectId), () -> this.getIdBsonWriter().writeObjectId(name, objectId));
        super.writeObjectId(name, objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.addBsonValue(() -> new BsonObjectId(objectId), () -> this.getIdBsonWriter().writeObjectId(objectId));
        super.writeObjectId(objectId);
    }

    @Override
    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> regularExpression, () -> this.getIdBsonWriter().writeRegularExpression(name, regularExpression));
        super.writeRegularExpression(name, regularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.addBsonValue(() -> regularExpression, () -> this.getIdBsonWriter().writeRegularExpression(regularExpression));
        super.writeRegularExpression(regularExpression);
    }

    @Override
    public void writeString(String name, String value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonString(value), () -> this.getIdBsonWriter().writeString(name, value));
        super.writeString(name, value);
    }

    @Override
    public void writeString(String value) {
        this.addBsonValue(() -> new BsonString(value), () -> this.getIdBsonWriter().writeString(value));
        super.writeString(value);
    }

    @Override
    public void writeSymbol(String name, String value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> new BsonSymbol(value), () -> this.getIdBsonWriter().writeSymbol(name, value));
        super.writeSymbol(name, value);
    }

    @Override
    public void writeSymbol(String value) {
        this.addBsonValue(() -> new BsonSymbol(value), () -> this.getIdBsonWriter().writeSymbol(value));
        super.writeSymbol(value);
    }

    @Override
    public void writeTimestamp(String name, BsonTimestamp value) {
        this.setCurrentFieldName(name);
        this.addBsonValue(() -> value, () -> this.getIdBsonWriter().writeTimestamp(name, value));
        super.writeTimestamp(name, value);
    }

    @Override
    public void writeTimestamp(BsonTimestamp value) {
        this.addBsonValue(() -> value, () -> this.getIdBsonWriter().writeTimestamp(value));
        super.writeTimestamp(value);
    }

    @Override
    public void writeUndefined(String name) {
        this.setCurrentFieldName(name);
        this.addBsonValue(BsonUndefined::new, () -> this.getIdBsonWriter().writeUndefined(name));
        super.writeUndefined(name);
    }

    @Override
    public void writeUndefined() {
        this.addBsonValue(BsonUndefined::new, this.getIdBsonWriter()::writeUndefined);
        super.writeUndefined();
    }

    @Override
    public void pipe(BsonReader reader) {
        super.pipe(reader);
    }

    @Override
    public void flush() {
        super.flush();
    }

    public BsonValue getId() {
        return this.id;
    }

    private void setCurrentFieldName(String name) {
        this.currentFieldName = name;
    }

    private boolean isWritingId() {
        return this.getIdBsonWriterCurrentLevel() >= 0 || this.getCurrentLevel() == 0 && this.currentFieldName != null && this.currentFieldName.equals(ID_FIELD_NAME);
    }

    private void addBsonValue(Supplier<BsonValue> value, Runnable writeValue) {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() >= 0) {
                writeValue.run();
            } else {
                this.id = value.get();
            }
        }
    }

    private int getIdBsonWriterCurrentLevel() {
        return this.idBsonBinaryWriter == null ? -1 : this.idBsonBinaryWriter.getCurrentLevel();
    }

    private LevelCountingBsonWriter getIdBsonWriter() {
        if (this.idBsonBinaryWriter == null) {
            this.outputBuffer = new BasicOutputBuffer(128);
            this.idBsonBinaryWriter = new LevelCountingBsonWriter(new BsonBinaryWriter(this.outputBuffer)){};
        }
        return this.idBsonBinaryWriter;
    }

    private byte[] getBytes() {
        return this.outputBuffer.getInternalBuffer();
    }
}

