/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Objects;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;

final class EventHelper {
    static boolean wouldDescriptionsGenerateEquivalentEvents(ClusterDescription current, ClusterDescription previous) {
        if (!EventHelper.exceptionsEquals(current.getSrvResolutionException(), previous.getSrvResolutionException())) {
            return false;
        }
        if (current.getServerDescriptions().size() != previous.getServerDescriptions().size()) {
            return false;
        }
        for (ServerDescription curNew : current.getServerDescriptions()) {
            ServerDescription matchingPrev = null;
            for (ServerDescription curPrev : previous.getServerDescriptions()) {
                if (!curNew.getAddress().equals(curPrev.getAddress())) continue;
                matchingPrev = curPrev;
                break;
            }
            if (EventHelper.wouldDescriptionsGenerateEquivalentEvents(curNew, matchingPrev)) continue;
            return false;
        }
        return true;
    }

    static boolean wouldDescriptionsGenerateEquivalentEvents(ServerDescription current, ServerDescription previous) {
        if (current == previous) {
            return true;
        }
        if (previous == null || current == null) {
            return false;
        }
        if (current.isOk() != previous.isOk()) {
            return false;
        }
        if (current.getState() != previous.getState()) {
            return false;
        }
        if (current.getType() != previous.getType()) {
            return false;
        }
        if (current.getMinWireVersion() != previous.getMinWireVersion()) {
            return false;
        }
        if (current.getMaxWireVersion() != previous.getMaxWireVersion()) {
            return false;
        }
        if (!Objects.equals(current.getCanonicalAddress(), previous.getCanonicalAddress())) {
            return false;
        }
        if (!current.getHosts().equals(previous.getHosts())) {
            return false;
        }
        if (!current.getPassives().equals(previous.getPassives())) {
            return false;
        }
        if (!current.getArbiters().equals(previous.getArbiters())) {
            return false;
        }
        if (!current.getTagSet().equals(previous.getTagSet())) {
            return false;
        }
        if (!Objects.equals(current.getSetName(), previous.getSetName())) {
            return false;
        }
        if (!Objects.equals(current.getSetVersion(), previous.getSetVersion())) {
            return false;
        }
        if (!Objects.equals(current.getElectionId(), previous.getElectionId())) {
            return false;
        }
        if (!Objects.equals(current.getPrimary(), previous.getPrimary())) {
            return false;
        }
        if (!Objects.equals(current.getLogicalSessionTimeoutMinutes(), previous.getLogicalSessionTimeoutMinutes())) {
            return false;
        }
        if (!Objects.equals(current.getTopologyVersion(), previous.getTopologyVersion())) {
            return false;
        }
        return EventHelper.exceptionsEquals(current.getException(), previous.getException());
    }

    private static boolean exceptionsEquals(Throwable current, Throwable previous) {
        if (current == null || previous == null) {
            return current == previous;
        }
        if (!Objects.equals(current.getClass(), previous.getClass())) {
            return false;
        }
        return Objects.equals(current.getMessage(), previous.getMessage());
    }

    private EventHelper() {
    }
}

