/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Collections;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCompressor;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCredential;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoDriverInformation;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.StreamFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerListener;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Cluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterableServer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterableServerFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultConnectionPool;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultServer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultServerMonitor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalStreamConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SdamServerDescriptionManager;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.event.EventListenerHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.inject.SameObjectProvider;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final StreamFactory heartbeatStreamFactory;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, MongoCredential credential, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, cluster.getClock(), new InternalStreamConnectionFactory(clusterMode, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), null, this.serverApi), clusterMode, this.serverApi, sdamProvider);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

