/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Collections;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCompressor;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCredential;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoDriverInformation;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.StreamFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ClusterListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerMonitorListener;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsynchronousClusterEventListener;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Cluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultClusterableServerFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultDnsSrvRecordMonitorFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DnsMultiServerCluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LoadBalancedCluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LoadBalancedClusterableServerFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MultiServerCluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SingleServerCluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.event.EventListenerHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public final class DefaultClusterFactory {
    public Cluster createCluster(ClusterSettings originalClusterSettings, ServerSettings originalServerSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        ServerSettings serverSettings;
        ClusterSettings clusterSettings;
        ClusterId clusterId = new ClusterId(applicationName);
        if (this.noClusterEventListeners(originalClusterSettings, originalServerSettings)) {
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(EventListenerHelper.NO_OP_CLUSTER_LISTENER)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_LISTENER)).serverMonitorListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER)).build();
        } else {
            AsynchronousClusterEventListener clusterEventListener = AsynchronousClusterEventListener.startNew(clusterId, DefaultClusterFactory.getClusterListener(originalClusterSettings), DefaultClusterFactory.getServerListener(originalServerSettings), DefaultClusterFactory.getServerMonitorListener(originalServerSettings));
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(clusterEventListener)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(clusterEventListener)).serverMonitorListenerList(Collections.singletonList(clusterEventListener)).build();
        }
        DefaultDnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory = new DefaultDnsSrvRecordMonitorFactory(clusterId, serverSettings);
        if (clusterSettings.getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            LoadBalancedClusterableServerFactory serverFactory = new LoadBalancedClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, credential, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi);
            return new LoadBalancedCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, heartbeatStreamFactory, credential, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi);
        if (clusterSettings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings, serverFactory);
        }
        if (clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE) {
            if (clusterSettings.getSrvHost() == null) {
                return new MultiServerCluster(clusterId, clusterSettings, serverFactory);
            }
            return new DnsMultiServerCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings.getMode()));
    }

    private boolean noClusterEventListeners(ClusterSettings clusterSettings, ServerSettings serverSettings) {
        return clusterSettings.getClusterListeners().isEmpty() && serverSettings.getServerListeners().isEmpty() && serverSettings.getServerMonitorListeners().isEmpty();
    }

    private static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        return clusterSettings.getClusterListeners().size() == 0 ? EventListenerHelper.NO_OP_CLUSTER_LISTENER : EventListenerHelper.clusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    private static ServerListener getServerListener(ServerSettings serverSettings) {
        return serverSettings.getServerListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_LISTENER : EventListenerHelper.serverListenerMulticaster(serverSettings.getServerListeners());
    }

    private static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        return serverSettings.getServerMonitorListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER : EventListenerHelper.serverMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }
}

