/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoInternalException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoInterruptedException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoServerUnavailableException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoTimeoutException;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Pool;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public class ConcurrentPool<T>
implements Pool<T> {
    public static final int INFINITE_SIZE = Integer.MAX_VALUE;
    private final int maxSize;
    private final ItemFactory<T> itemFactory;
    private final Deque<T> available = new ConcurrentLinkedDeque<T>();
    private final StateAndPermits stateAndPermits;
    private final String poolClosedMessage;

    public ConcurrentPool(int maxSize, ItemFactory<T> itemFactory) {
        this(maxSize, itemFactory, "The pool is closed");
    }

    public ConcurrentPool(int maxSize, ItemFactory<T> itemFactory, String poolClosedMessage) {
        Assertions.assertTrue(maxSize > 0);
        this.maxSize = maxSize;
        this.itemFactory = itemFactory;
        this.stateAndPermits = new StateAndPermits(maxSize, this::poolClosedException);
        this.poolClosedMessage = Assertions.notNull("poolClosedMessage", poolClosedMessage);
    }

    @Override
    public void release(T t) {
        this.release(t, false);
    }

    @Override
    public void release(T t, boolean prune) {
        if (t == null) {
            throw new IllegalArgumentException("Can not return a null item to the pool");
        }
        if (this.stateAndPermits.closed()) {
            this.close(t);
            return;
        }
        if (prune) {
            this.close(t);
        } else {
            this.available.addLast(t);
        }
        this.stateAndPermits.releasePermit();
    }

    @Override
    public T get() {
        return this.get(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public T get(long timeout, TimeUnit timeUnit) {
        if (!this.stateAndPermits.acquirePermit(timeout, timeUnit)) {
            throw new MongoTimeoutException(String.format("Timeout waiting for a pooled item after %d %s", new Object[]{timeout, timeUnit}));
        }
        T t = this.available.pollLast();
        if (t == null) {
            t = this.createNewAndReleasePermitIfFailure();
        }
        return t;
    }

    @Nullable
    T getImmediateUnfair() {
        T element = null;
        if (this.stateAndPermits.acquirePermitImmediateUnfair() && (element = (T)this.available.pollLast()) == null) {
            this.stateAndPermits.releasePermit();
        }
        return element;
    }

    public void prune() {
        int maxIterations = this.available.size();
        int numIterations = 0;
        for (T cur : this.available) {
            if (this.itemFactory.shouldPrune(cur) && this.available.remove(cur)) {
                this.close(cur);
            }
            if (++numIterations != maxIterations) continue;
            break;
        }
    }

    public void ensureMinSize(int minSize, Consumer<T> initAndRelease) {
        while (this.getCount() < minSize && this.stateAndPermits.acquirePermit(0L, TimeUnit.MILLISECONDS)) {
            initAndRelease.accept(this.createNewAndReleasePermitIfFailure());
        }
    }

    private T createNewAndReleasePermitIfFailure() {
        try {
            T newMember = this.itemFactory.create();
            if (newMember == null) {
                throw new MongoInternalException("The factory for the pool created a null item");
            }
            return newMember;
        }
        catch (Exception e) {
            this.stateAndPermits.releasePermit();
            throw e;
        }
    }

    boolean acquirePermit(long timeout, TimeUnit timeUnit) {
        return this.stateAndPermits.acquirePermit(timeout, timeUnit);
    }

    @Override
    public void close() {
        if (this.stateAndPermits.close()) {
            Iterator<T> iter = this.available.iterator();
            while (iter.hasNext()) {
                T t = iter.next();
                this.close(t);
                iter.remove();
            }
        }
    }

    int getMaxSize() {
        return this.maxSize;
    }

    public int getInUseCount() {
        return this.maxSize - this.stateAndPermits.permits();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getCount() {
        return this.getInUseCount() + this.getAvailableCount();
    }

    public String toString() {
        return "pool:  maxSize: " + ConcurrentPool.sizeToString(this.maxSize) + " availableCount " + this.getAvailableCount() + " inUseCount " + this.getInUseCount();
    }

    private void close(T t) {
        try {
            this.itemFactory.close(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void ready() {
        this.stateAndPermits.ready();
    }

    void pause(Supplier<MongoException> causeSupplier) {
        this.stateAndPermits.pause(causeSupplier);
    }

    MongoServerUnavailableException poolClosedException() {
        return new MongoServerUnavailableException(this.poolClosedMessage);
    }

    static boolean isPoolClosedException(Throwable e) {
        return e instanceof MongoServerUnavailableException;
    }

    static String sizeToString(int size) {
        return size == Integer.MAX_VALUE ? "infinite" : Integer.toString(size);
    }

    static void lockInterruptibly(Lock lock) throws MongoInterruptedException {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(null, e);
        }
    }

    private static void lockInterruptiblyUnfair(ReentrantLock lock) throws MongoInterruptedException {
        ConcurrentPool.throwIfInterrupted();
        if (!lock.tryLock()) {
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MongoInterruptedException(null, new InterruptedException());
            }
        }
    }

    static void lockUnfair(ReentrantLock lock) {
        if (!lock.tryLock()) {
            lock.lock();
        }
    }

    private static void throwIfInterrupted() throws MongoInterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new MongoInterruptedException(null, new InterruptedException());
        }
    }

    public static interface ItemFactory<T> {
        public T create();

        public void close(T var1);

        public boolean shouldPrune(T var1);
    }

    @ThreadSafe
    private static final class StateAndPermits {
        private final Supplier<MongoServerUnavailableException> poolClosedExceptionSupplier;
        private final ReentrantLock lock;
        private final Condition permitAvailableOrClosedOrPausedCondition;
        private volatile boolean paused;
        private volatile boolean closed;
        private final int maxPermits;
        private volatile int permits;
        private final AtomicInteger waitersEstimate;
        @Nullable
        private Supplier<MongoException> causeSupplier;

        StateAndPermits(int maxPermits, Supplier<MongoServerUnavailableException> poolClosedExceptionSupplier) {
            this.poolClosedExceptionSupplier = poolClosedExceptionSupplier;
            this.lock = new ReentrantLock(true);
            this.permitAvailableOrClosedOrPausedCondition = this.lock.newCondition();
            this.paused = false;
            this.closed = false;
            this.maxPermits = maxPermits;
            this.permits = maxPermits;
            this.waitersEstimate = new AtomicInteger();
            this.causeSupplier = null;
        }

        int permits() {
            return this.permits;
        }

        boolean acquirePermitImmediateUnfair() {
            ConcurrentPool.lockUnfair(this.lock);
            try {
                this.throwIfClosedOrPaused();
                if (this.permits > 0) {
                    --this.permits;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean acquirePermit(long timeout, TimeUnit unit) throws MongoInterruptedException {
            long remainingNanos = unit.toNanos(timeout);
            if (this.waitersEstimate.get() == 0) {
                ConcurrentPool.lockInterruptiblyUnfair(this.lock);
            } else {
                ConcurrentPool.lockInterruptibly(this.lock);
            }
            try {
                while (this.permits == 0 & !this.throwIfClosedOrPaused()) {
                    try {
                        this.waitersEstimate.incrementAndGet();
                        if (timeout < 0L || remainingNanos == Long.MAX_VALUE) {
                            this.permitAvailableOrClosedOrPausedCondition.await();
                            continue;
                        }
                        if (remainingNanos >= 0L) {
                            remainingNanos = this.permitAvailableOrClosedOrPausedCondition.awaitNanos(remainingNanos);
                            continue;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (InterruptedException e) {
                        throw new MongoInterruptedException(null, e);
                    }
                    finally {
                        this.waitersEstimate.decrementAndGet();
                    }
                }
                Assertions.assertTrue(this.permits > 0);
                --this.permits;
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        void releasePermit() {
            ConcurrentPool.lockUnfair(this.lock);
            try {
                Assertions.assertTrue(this.permits < this.maxPermits);
                ++this.permits;
                this.permitAvailableOrClosedOrPausedCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        void pause(Supplier<MongoException> causeSupplier) {
            ConcurrentPool.lockUnfair(this.lock);
            try {
                if (!this.paused) {
                    this.paused = true;
                    this.permitAvailableOrClosedOrPausedCondition.signalAll();
                }
                this.causeSupplier = Assertions.assertNotNull(causeSupplier);
            }
            finally {
                this.lock.unlock();
            }
        }

        void ready() {
            if (this.paused) {
                ConcurrentPool.lockUnfair(this.lock);
                try {
                    this.paused = false;
                    this.causeSupplier = null;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        boolean close() {
            if (!this.closed) {
                ConcurrentPool.lockUnfair(this.lock);
                try {
                    if (!this.closed) {
                        this.closed = true;
                        this.permitAvailableOrClosedOrPausedCondition.signalAll();
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        }

        boolean throwIfClosedOrPaused() {
            if (this.closed) {
                throw this.poolClosedExceptionSupplier.get();
            }
            if (this.paused) {
                throw Assertions.assertNotNull(Assertions.assertNotNull(this.causeSupplier).get());
            }
            return false;
        }

        boolean closed() {
            return this.closed;
        }
    }
}

