/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ReplyMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ResponseBuffers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ResponseCallback;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

abstract class CommandResultBaseCallback<T>
extends ResponseCallback {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final Decoder<T> decoder;

    CommandResultBaseCallback(Decoder<T> decoder, long requestId, ServerAddress serverAddress) {
        super(requestId, serverAddress);
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callCallback(ResponseBuffers responseBuffers, Throwable t) {
        try {
            if (t != null || responseBuffers == null) {
                this.callCallback((T)null, t);
            } else {
                ReplyMessage<T> replyMessage = new ReplyMessage<T>(responseBuffers, this.decoder, this.getRequestId());
                this.callCallback(replyMessage.getDocuments().get(0), null);
            }
        }
        finally {
            try {
                if (responseBuffers != null) {
                    responseBuffers.close();
                }
            }
            catch (Throwable t1) {
                LOGGER.debug("GetMore ResponseBuffer close exception", t1);
            }
        }
    }

    protected abstract void callCallback(T var1, Throwable var2);
}

