/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.Locale;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoServerException;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.IgnorableRequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterClock;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandMessage;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MessageSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.NoOpSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;

public final class CommandHelper {
    static final String HELLO = "hello";
    static final String LEGACY_HELLO = "isMaster";
    static final String LEGACY_HELLO_LOWER = "isMaster".toLowerCase(Locale.ROOT);

    static BsonDocument executeCommand(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
    }

    public static BsonDocument executeCommand(String database, BsonDocument command, ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, clusterClock, clusterConnectionMode, serverApi, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, final SingleResultCallback<BsonDocument> callback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, IgnorableRequestContext.INSTANCE, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        SessionContext sessionContext = clusterClock == null ? NoOpSessionContext.INSTANCE : new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, clusterClock);
        return internalConnection.sendAndReceive(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), sessionContext, IgnorableRequestContext.INSTANCE);
    }

    private static CommandMessage getCommandMessage(String database, BsonDocument command, InternalConnection internalConnection, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return new CommandMessage(new MongoNamespace(database, "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).build(), clusterConnectionMode, serverApi);
    }

    private CommandHelper() {
    }
}

