/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoBulkWriteException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.bulk.BulkWriteError;
import org.apache.flink.mongodb.shaded.com.mongodb.bulk.BulkWriteInsert;
import org.apache.flink.mongodb.shaded.com.mongodb.bulk.BulkWriteResult;
import org.apache.flink.mongodb.shaded.com.mongodb.bulk.BulkWriteUpsert;
import org.apache.flink.mongodb.shaded.com.mongodb.bulk.WriteConcernError;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.IndexMap;

public class BulkWriteBatchCombiner {
    private final ServerAddress serverAddress;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private int insertedCount;
    private int matchedCount;
    private int deletedCount;
    private int modifiedCount = 0;
    private final Set<BulkWriteUpsert> writeUpserts = new TreeSet<BulkWriteUpsert>(Comparator.comparingInt(BulkWriteUpsert::getIndex));
    private final Set<BulkWriteInsert> writeInserts = new TreeSet<BulkWriteInsert>(Comparator.comparingInt(BulkWriteInsert::getIndex));
    private final Set<BulkWriteError> writeErrors = new TreeSet<BulkWriteError>(Comparator.comparingInt(BulkWriteError::getIndex));
    private final Set<String> errorLabels = new HashSet<String>();
    private final List<WriteConcernError> writeConcernErrors = new ArrayList<WriteConcernError>();

    public BulkWriteBatchCombiner(ServerAddress serverAddress, boolean ordered, WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.ordered = ordered;
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public void addResult(BulkWriteResult result) {
        this.insertedCount += result.getInsertedCount();
        this.matchedCount += result.getMatchedCount();
        this.deletedCount += result.getDeletedCount();
        this.modifiedCount += result.getModifiedCount();
        this.writeUpserts.addAll(result.getUpserts());
        this.writeInserts.addAll(result.getInserts());
    }

    public void addErrorResult(MongoBulkWriteException exception, IndexMap indexMap) {
        this.addResult(exception.getWriteResult());
        this.errorLabels.addAll(exception.getErrorLabels());
        this.mergeWriteErrors(exception.getWriteErrors(), indexMap);
        this.mergeWriteConcernError(exception.getWriteConcernError());
    }

    public void addWriteErrorResult(BulkWriteError writeError, IndexMap indexMap) {
        Assertions.notNull("writeError", writeError);
        this.mergeWriteErrors(Collections.singletonList(writeError), indexMap);
    }

    public void addWriteConcernErrorResult(WriteConcernError writeConcernError) {
        Assertions.notNull("writeConcernError", writeConcernError);
        this.mergeWriteConcernError(writeConcernError);
    }

    public void addErrorResult(List<BulkWriteError> writeErrors, WriteConcernError writeConcernError, IndexMap indexMap) {
        this.mergeWriteErrors(writeErrors, indexMap);
        this.mergeWriteConcernError(writeConcernError);
    }

    public BulkWriteResult getResult() {
        this.throwOnError();
        return this.createResult();
    }

    public boolean shouldStopSendingMoreBatches() {
        return this.ordered && this.hasWriteErrors();
    }

    public boolean hasErrors() {
        return this.hasWriteErrors() || this.hasWriteConcernErrors();
    }

    public MongoBulkWriteException getError() {
        if (!this.hasErrors()) {
            return null;
        }
        return new MongoBulkWriteException(this.createResult(), new ArrayList<BulkWriteError>(this.writeErrors), this.writeConcernErrors.isEmpty() ? null : this.writeConcernErrors.get(this.writeConcernErrors.size() - 1), this.serverAddress, this.errorLabels);
    }

    private void mergeWriteConcernError(WriteConcernError writeConcernError) {
        if (writeConcernError != null) {
            if (this.writeConcernErrors.isEmpty()) {
                this.writeConcernErrors.add(writeConcernError);
                this.errorLabels.addAll(writeConcernError.getErrorLabels());
            } else if (!writeConcernError.equals(this.writeConcernErrors.get(this.writeConcernErrors.size() - 1))) {
                this.writeConcernErrors.add(writeConcernError);
                this.errorLabels.addAll(writeConcernError.getErrorLabels());
            }
        }
    }

    private void mergeWriteErrors(List<BulkWriteError> newWriteErrors, IndexMap indexMap) {
        for (BulkWriteError cur : newWriteErrors) {
            this.writeErrors.add(new BulkWriteError(cur.getCode(), cur.getMessage(), cur.getDetails(), indexMap.map(cur.getIndex())));
        }
    }

    private void throwOnError() {
        if (this.hasErrors()) {
            throw this.getError();
        }
    }

    private BulkWriteResult createResult() {
        return this.writeConcern.isAcknowledged() ? BulkWriteResult.acknowledged(this.insertedCount, this.matchedCount, this.deletedCount, this.modifiedCount, new ArrayList<BulkWriteUpsert>(this.writeUpserts), new ArrayList<BulkWriteInsert>(this.writeInserts)) : BulkWriteResult.unacknowledged();
    }

    private boolean hasWriteErrors() {
        return !this.writeErrors.isEmpty();
    }

    private boolean hasWriteConcernErrors() {
        return !this.writeConcernErrors.isEmpty();
    }
}

