/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.client.model;

import java.util.Iterator;
import org.apache.flink.mongodb.shaded.com.mongodb.Function;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.FieldSearchPath;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchPath;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;

public final class Util {
    public static final String SEARCH_PATH_VALUE_KEY = "value";

    public static BsonValue combineToBsonValue(Iterator<? extends SearchPath> nonEmptyPaths, boolean valueOnly) {
        Function<SearchPath, BsonValue> toBsonValueFunc = valueOnly ? path -> {
            if (path instanceof FieldSearchPath) {
                return new BsonString(((FieldSearchPath)path).toValue());
            }
            return path.toBsonValue();
        } : SearchPath::toBsonValue;
        BsonValue firstPath = toBsonValueFunc.apply(nonEmptyPaths.next());
        if (nonEmptyPaths.hasNext()) {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(firstPath);
            while (nonEmptyPaths.hasNext()) {
                bsonArray.add(toBsonValueFunc.apply(nonEmptyPaths.next()));
            }
            return bsonArray;
        }
        return firstPath;
    }

    public static boolean sizeAtLeast(Iterable<?> iterable, int minInclusive) {
        int size;
        Iterator<?> iter = iterable.iterator();
        for (size = 0; size < minInclusive && iter.hasNext(); ++size) {
            iter.next();
        }
        return size >= minInclusive;
    }

    private Util() {
        throw Assertions.fail();
    }
}

