/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.search;

import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Beta;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Evolving;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.ConstantSearchScore;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.FieldSearchPath;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.FunctionSearchScore;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.PathBoostSearchScore;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchConstructibleBsonElement;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchScoreExpression;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.ValueBoostSearchScore;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonDouble;
import org.apache.flink.mongodb.shaded.org.bson.Document;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

