/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.search;

import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Beta;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Evolving;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.FieldSearchPath;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchConstructibleBson;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.WildcardSearchPath;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String path) {
        Assertions.notNull("path", path);
        Assertions.isTrueArgument("path must not contain '*'", !path.contains("*"));
        return new SearchConstructibleBson(new BsonDocument("value", new BsonString(path)));
    }

    public static WildcardSearchPath wildcardPath(String wildcardPath) {
        Assertions.notNull("wildcardPath", wildcardPath);
        Assertions.isTrueArgument("wildcardPath must contain '*'", wildcardPath.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !wildcardPath.contains("**"));
        return new SearchConstructibleBson(new BsonDocument("wildcard", new BsonString(wildcardPath)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument doc = this.toBsonDocument();
        if (doc.size() > 1) {
            return doc;
        }
        BsonString value = doc.getString("value", null);
        if (value != null) {
            return value;
        }
        return doc;
    }
}

