/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.search;

import java.util.Iterator;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Beta;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Evolving;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchConstructibleBson;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchPath;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.Iterables;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.client.model.Util;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

