/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.search;

import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Beta;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Evolving;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.FacetSearchCollector;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchConstructibleBsonElement;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchFacet;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.search.SearchOperator;
import org.apache.flink.mongodb.shaded.org.bson.Document;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchCollector
extends Bson {
    @Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
    public static FacetSearchCollector facet(SearchOperator operator, Iterable<? extends SearchFacet> facets) {
        Assertions.notNull("operator", operator);
        Assertions.notNull("facets", facets);
        return new SearchConstructibleBsonElement("facet", (Bson)new Document("operator", operator).append("facets", SearchFacet.combineToBson(facets)));
    }

    public static SearchCollector of(Bson collector) {
        return new SearchConstructibleBsonElement(Assertions.notNull("collector", collector));
    }
}

