/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.densify;

import java.time.Instant;
import java.util.Arrays;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Evolving;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.MongoTimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.densify.DateDensifyRange;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.densify.DensifyConstructibleBson;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.densify.NumberDensifyRange;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.Document;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Evolving
public interface DensifyRange
extends Bson {
    public static NumberDensifyRange fullRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "full").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange partitionRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "partition").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange rangeWithStep(Number l, Number u, Number step) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("step", step);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", Assertions.notNull("step", step)));
    }

    public static DateDensifyRange fullRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("full")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange partitionRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("partition")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange rangeWithStep(Instant l, Instant u, long step, MongoTimeUnit unit) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", step).append("unit", unit.value()));
    }

    public static DensifyRange of(Bson range) {
        return new DensifyConstructibleBson(Assertions.notNull("range", range));
    }
}

