/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.BsonField;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.BuildersHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.MongoTimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Window;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.WindowOutputField;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocumentWriter;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

public final class WindowOutputFields {
    public static WindowOutputField of(BsonField windowOutputField) {
        return new BsonFieldWindowOutputField(org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("windowOutputField", windowOutputField));
    }

    public static <TExpression> WindowOutputField sum(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$sum", expression, window);
    }

    public static <TExpression> WindowOutputField avg(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$avg", expression, window);
    }

    public static <TExpression> WindowOutputField stdDevSamp(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$stdDevSamp", expression, window);
    }

    public static <TExpression> WindowOutputField stdDevPop(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$stdDevPop", expression, window);
    }

    public static <TExpression> WindowOutputField min(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$min", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField minN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("inExpression", inExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.INPUT, inExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$minN", args, window);
    }

    public static <TExpression> WindowOutputField max(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$max", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField maxN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("inExpression", inExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.INPUT, inExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$maxN", args, window);
    }

    public static WindowOutputField count(String path, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$count", null, window);
    }

    public static <TExpression> WindowOutputField derivative(String path, TExpression expression, Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("window", window);
        HashMap<ParamName, Object> args = new HashMap<ParamName, Object>(1);
        args.put(ParamName.INPUT, expression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$derivative", args, window);
    }

    public static <TExpression> WindowOutputField timeDerivative(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("window", window);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("unit", unit);
        Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.UNIT, unit.value());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$derivative", args, window);
    }

    public static <TExpression> WindowOutputField integral(String path, TExpression expression, Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("window", window);
        HashMap<ParamName, Object> args = new HashMap<ParamName, Object>(1);
        args.put(ParamName.INPUT, expression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$integral", args, window);
    }

    public static <TExpression> WindowOutputField timeIntegral(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("window", window);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("unit", unit);
        Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.UNIT, unit.value());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$integral", args, window);
    }

    public static <TExpression> WindowOutputField covarianceSamp(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression1", expression1);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$covarianceSamp", expressions, window);
    }

    public static <TExpression> WindowOutputField covariancePop(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression1", expression1);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$covariancePop", expressions, window);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String path, TExpression expression, int n) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        Assertions.isTrueArgument("n > 0", n > 0);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.N_UPPERCASE, n);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$expMovingAvg", args, null);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String path, TExpression expression, double alpha) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        Assertions.isTrueArgument("alpha > 0", alpha > 0.0);
        Assertions.isTrueArgument("alpha < 1", alpha < 1.0);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.ALPHA, alpha);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$expMovingAvg", args, null);
    }

    public static <TExpression> WindowOutputField push(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$push", expression, window);
    }

    public static <TExpression> WindowOutputField addToSet(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$addToSet", expression, window);
    }

    public static <TExpression> WindowOutputField first(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$first", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField firstN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("inExpression", inExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.INPUT, inExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$firstN", args, window);
    }

    public static <OutExpression> WindowOutputField top(String path, Bson sortBy, OutExpression outExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("sortBy", sortBy);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("outExpression", outExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.SORT_BY, sortBy);
        args.put(ParamName.OUTPUT, outExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$top", args, window);
    }

    public static <OutExpression, NExpression> WindowOutputField topN(String path, Bson sortBy, OutExpression outExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("sortBy", sortBy);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("outExpression", outExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.SORT_BY, sortBy);
        args.put(ParamName.OUTPUT, outExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$topN", args, window);
    }

    public static <TExpression> WindowOutputField last(String path, TExpression expression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$last", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField lastN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("inExpression", inExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.INPUT, inExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$lastN", args, window);
    }

    public static <OutExpression> WindowOutputField bottom(String path, Bson sortBy, OutExpression outExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("sortBy", sortBy);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("outExpression", outExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.SORT_BY, sortBy);
        args.put(ParamName.OUTPUT, outExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$bottom", args, window);
    }

    public static <OutExpression, NExpression> WindowOutputField bottomN(String path, Bson sortBy, OutExpression outExpression, NExpression nExpression, @Nullable Window window) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("sortBy", sortBy);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("outExpression", outExpression);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.SORT_BY, sortBy);
        args.put(ParamName.OUTPUT, outExpression);
        args.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$bottomN", args, window);
    }

    public static <TExpression> WindowOutputField shift(String path, TExpression expression, @Nullable TExpression defaultExpression, int by) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.OUTPUT, expression);
        args.put(ParamName.BY, by);
        if (defaultExpression != null) {
            args.put(ParamName.DEFAULT, defaultExpression);
        }
        return WindowOutputFields.compoundParameterWindowFunction(path, "$shift", args, null);
    }

    public static WindowOutputField documentNumber(String path) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$documentNumber", null, null);
    }

    public static WindowOutputField rank(String path) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$rank", null, null);
    }

    public static WindowOutputField denseRank(String path) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$denseRank", null, null);
    }

    public static <TExpression> WindowOutputField locf(String path, TExpression expression) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$locf", expression, null);
    }

    public static <TExpression> WindowOutputField linearFill(String path, TExpression expression) {
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("path", path);
        org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$linearFill", expression, null);
    }

    private static WindowOutputField simpleParameterWindowFunction(String path, String functionName, @Nullable Object expression, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(path, new SimpleParameterFunctionAndWindow(functionName, expression, window)));
    }

    private static WindowOutputField compoundParameterWindowFunction(String path, String functionName, Map<ParamName, Object> args, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(path, new CompoundParameterFunctionAndWindow(functionName, args, window)));
    }

    private WindowOutputFields() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonFieldWindowOutputField
    implements WindowOutputField {
        private final BsonField wrapped;

        BsonFieldWindowOutputField(BsonField field) {
            this.wrapped = Assertions.assertNotNull(field);
        }

        @Override
        public BsonField toBsonField() {
            return this.wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsonFieldWindowOutputField that = (BsonFieldWindowOutputField)o;
            return this.wrapped.equals(that.wrapped);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static enum ParamName {
        INPUT("input"),
        UNIT("unit"),
        N_UPPERCASE("N"),
        N_LOWERCASE("n"),
        ALPHA("alpha"),
        OUTPUT("output"),
        BY("by"),
        DEFAULT("default"),
        SORT_BY("sortBy");

        private final String value;

        private ParamName(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }

    private static final class SimpleParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        @Nullable
        private final Object expression;

        SimpleParameterFunctionAndWindow(String functionName, @Nullable Object expression, @Nullable Window window) {
            super(functionName, window);
            this.expression = expression;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            if (this.expression == null) {
                writer.writeStartDocument();
                writer.writeEndDocument();
            } else {
                BuildersHelper.encodeValue(writer, this.expression, codecRegistry);
            }
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleParameterFunctionAndWindow that = (SimpleParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.expression, that.expression) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.expression, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", expression=" + this.expression + ", window=" + this.window() + '}';
        }
    }

    private static final class CompoundParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        private final Map<ParamName, Object> args;

        CompoundParameterFunctionAndWindow(String functionName, Map<ParamName, Object> args, @Nullable Window window) {
            super(functionName, window);
            this.args = args;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            writer.writeStartDocument();
            this.args.forEach((paramName, paramValue) -> {
                writer.writeName(paramName.value());
                BuildersHelper.encodeValue(writer, paramValue, codecRegistry);
            });
            writer.writeEndDocument();
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundParameterFunctionAndWindow that = (CompoundParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.args, that.args) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.args, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", args=" + this.args + ", window=" + this.window() + '}';
        }
    }

    private static abstract class AbstractFunctionAndWindow
    implements Bson {
        private final String functionName;
        @Nullable
        private final Window window;

        AbstractFunctionAndWindow(String functionName, @Nullable Window window) {
            this.functionName = functionName;
            this.window = window;
        }

        final void writeWindow(CodecRegistry codecRegistry, BsonDocumentWriter writer) {
            if (this.window != null) {
                writer.writeName("window");
                BuildersHelper.encodeValue(writer, this.window, codecRegistry);
            }
        }

        final String functionName() {
            return this.functionName;
        }

        final Optional<Window> window() {
            return Optional.ofNullable(this.window);
        }
    }
}

