/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.internal;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.flink.mongodb.shaded.com.mongodb.Function;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoIterable;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.MongoMappingCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public MongoCursor<V> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public V first() {
        U first = this.iterable.first();
        if (first == null) {
            return null;
        }
        return this.mapper.apply(first);
    }

    @Override
    public void forEach(final Consumer<? super V> block) {
        this.iterable.forEach(new Consumer<U>(){

            @Override
            public void accept(U document) {
                block.accept(MappingIterable.this.mapper.apply(document));
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> A into(final A target) {
        this.forEach(new Consumer<V>(){

            @Override
            public void accept(V v) {
                target.add(v);
            }
        });
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }
}

