/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.internal;

import java.util.HashMap;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoClientException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.RequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcernResult;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.Crypt;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.DeleteRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.InsertRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.UpdateRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MessageSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.QueryResult;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SplittablePayload;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SplittablePayloadBsonWriter;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ServerVersionHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.validator.MappedFieldNameValidator;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinaryReader;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinaryWriter;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinaryWriterSettings;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonWriter;
import org.apache.flink.mongodb.shaded.org.bson.BsonWriterSettings;
import org.apache.flink.mongodb.shaded.org.bson.FieldNameValidator;
import org.apache.flink.mongodb.shaded.org.bson.RawBsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonValueCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DecoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.EncoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.RawBsonDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistries;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;
import org.apache.flink.mongodb.shaded.org.bson.io.BasicOutputBuffer;
import org.apache.flink.mongodb.shaded.org.bson.io.BsonOutput;

class CryptConnection
implements Connection {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int MAX_SPLITTABLE_DOCUMENT_SIZE = 0x200000;
    private final Connection wrapped;
    private final Crypt crypt;

    CryptConnection(Connection wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public CryptConnection retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(this.wrapped.getDescription())) {
            throw new MongoClientException("Auto-encryption requires a minimum MongoDB version of 4.2");
        }
        BasicOutputBuffer bsonOutput = new BasicOutputBuffer();
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getDescription().getMaxDocumentSize()), bsonOutput, this.getFieldNameValidator(payload, commandFieldNameValidator, payloadFieldNameValidator));
        BsonWriter writer = payload == null ? bsonBinaryWriter : new SplittablePayloadBsonWriter(bsonBinaryWriter, (BsonOutput)bsonOutput, this.createSplittablePayloadMessageSettings(), payload, 0x200000);
        this.getEncoder(command).encode(writer, command, EncoderContext.builder().build());
        RawBsonDocument encryptedCommand = this.crypt.encrypt(database, new RawBsonDocument(bsonOutput.getInternalBuffer(), 0, bsonOutput.getSize()));
        RawBsonDocument encryptedResponse = this.wrapped.command(database, encryptedCommand, commandFieldNameValidator, readPreference, new RawBsonDocumentCodec(), sessionContext, serverApi, requestContext, responseExpected, null, null);
        RawBsonDocument decryptedResponse = this.crypt.decrypt(encryptedResponse);
        BsonBinaryReader reader = new BsonBinaryReader(decryptedResponse.getByteBuffer().asNIO());
        return commandResultDecoder.decode(reader, DecoderContext.builder().build());
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, true, null, null);
    }

    private Codec<BsonDocument> getEncoder(BsonDocument command) {
        return REGISTRY.get(command.getClass());
    }

    private FieldNameValidator getFieldNameValidator(@Nullable SplittablePayload payload, FieldNameValidator commandFieldNameValidator, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (payload == null) {
            return commandFieldNameValidator;
        }
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put(payload.getPayloadName(), payloadFieldNameValidator);
        return new MappedFieldNameValidator(commandFieldNameValidator, rootMap);
    }

    private MessageSettings createSplittablePayloadMessageSettings() {
        return MessageSettings.builder().maxBatchCount(this.getDescription().getMaxBatchCount()).maxMessageSize(this.getDescription().getMaxMessageSize()).maxDocumentSize(this.getDescription().getMaxDocumentSize()).build();
    }

    @Override
    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean secondaryOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void killCursor(MongoNamespace namespace, List<Long> cursors, RequestContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }
}

