/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb;

import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.flink.mongodb.shaded.com.mongodb.SubjectProvider;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.NonNull;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

@ThreadSafe
public class KerberosSubjectProvider
implements SubjectProvider {
    private static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String TGT_PREFIX = "krbtgt/";
    private String loginContextName;
    private String fallbackLoginContextName;
    private Subject subject;

    public KerberosSubjectProvider() {
        this("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate");
    }

    public KerberosSubjectProvider(String loginContextName) {
        this(loginContextName, null);
    }

    private KerberosSubjectProvider(String loginContextName, @Nullable String fallbackLoginContextName) {
        this.loginContextName = Assertions.notNull("loginContextName", loginContextName);
        this.fallbackLoginContextName = fallbackLoginContextName;
    }

    @Override
    @NonNull
    public synchronized Subject getSubject() throws LoginException {
        if (this.subject == null || KerberosSubjectProvider.needNewSubject(this.subject)) {
            this.subject = this.createNewSubject();
        }
        return this.subject;
    }

    private Subject createNewSubject() throws LoginException {
        LoginContext loginContext;
        try {
            LOGGER.debug(String.format("Creating LoginContext with name '%s'", this.loginContextName));
            loginContext = new LoginContext(this.loginContextName);
        }
        catch (LoginException e) {
            if (this.fallbackLoginContextName == null) {
                throw e;
            }
            LOGGER.debug(String.format("Creating LoginContext with fallback name '%s'", this.fallbackLoginContextName));
            loginContext = new LoginContext(this.fallbackLoginContextName);
            this.loginContextName = this.fallbackLoginContextName;
            this.fallbackLoginContextName = null;
        }
        loginContext.login();
        LOGGER.debug("Login successful");
        return loginContext.getSubject();
    }

    private static boolean needNewSubject(Subject subject) {
        for (KerberosTicket cur : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!cur.getServer().getName().startsWith(TGT_PREFIX)) continue;
            if (System.currentTimeMillis() <= cur.getEndTime().getTime() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)) break;
            LOGGER.info("The TGT is close to expiring. Time to reacquire.");
            return true;
        }
        return false;
    }
}

