/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb;

import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;

public abstract class CreateIndexCommitQuorum {
    public static final CreateIndexCommitQuorum MAJORITY = new CreateIndexCommitQuorumWithMode("majority");
    public static final CreateIndexCommitQuorum VOTING_MEMBERS = new CreateIndexCommitQuorumWithMode("votingMembers");

    public static CreateIndexCommitQuorum create(String mode) {
        return new CreateIndexCommitQuorumWithMode(mode);
    }

    public static CreateIndexCommitQuorum create(int w) {
        return new CreateIndexCommitQuorumWithW(w);
    }

    public abstract BsonValue toBsonValue();

    private CreateIndexCommitQuorum() {
    }

    private static final class CreateIndexCommitQuorumWithMode
    extends CreateIndexCommitQuorum {
        private final String mode;

        private CreateIndexCommitQuorumWithMode(String mode) {
            Assertions.notNull("mode", mode);
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        @Override
        public BsonValue toBsonValue() {
            return new BsonString(this.mode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CreateIndexCommitQuorumWithMode that = (CreateIndexCommitQuorumWithMode)o;
            return this.mode.equals(that.mode);
        }

        public int hashCode() {
            return this.mode.hashCode();
        }

        public String toString() {
            return "CreateIndexCommitQuorum{mode=" + this.mode + '}';
        }
    }

    private static final class CreateIndexCommitQuorumWithW
    extends CreateIndexCommitQuorum {
        private final int w;

        private CreateIndexCommitQuorumWithW(int w) {
            if (w < 0) {
                throw new IllegalArgumentException("w cannot be less than zero");
            }
            this.w = w;
        }

        public int getW() {
            return this.w;
        }

        @Override
        public BsonValue toBsonValue() {
            return new BsonInt32(this.w);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CreateIndexCommitQuorumWithW that = (CreateIndexCommitQuorumWithW)o;
            return this.w == that.w;
        }

        public int hashCode() {
            return this.w;
        }

        public String toString() {
            return "CreateIndexCommitQuorum{w=" + this.w + '}';
        }
    }
}

