/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table.serialization;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.mongodb.source.reader.deserializer.MongoDeserializationSchema;
import org.apache.flink.connector.mongodb.table.converter.BsonToRowDataConverters;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class MongoRowDataDeserializationSchema
implements MongoDeserializationSchema<RowData> {
    private final TypeInformation<RowData> typeInfo;
    private final BsonToRowDataConverters.BsonToRowDataConverter runtimeConverter;

    public MongoRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> typeInfo) {
        this.typeInfo = typeInfo;
        this.runtimeConverter = BsonToRowDataConverters.createConverter(rowType);
    }

    @Override
    public RowData deserialize(BsonDocument document) {
        return this.runtimeConverter.convert(document);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.typeInfo;
    }
}

