/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonBinary;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDateTime;
import org.apache.flink.mongodb.shaded.org.bson.BsonDecimal128;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonDouble;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;
import org.apache.flink.mongodb.shaded.org.bson.BsonNull;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.json.JsonParseException;
import org.apache.flink.mongodb.shaded.org.bson.types.Decimal128;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.function.SerializableFunction;

@Internal
public class RowDataToBsonConverters {
    public static RowDataToBsonConverter createConverter(RowType type) {
        final SerializableFunction<Object, BsonValue> internalRowConverter = RowDataToBsonConverters.createNullSafeInternalConverter((LogicalType)type);
        return new RowDataToBsonConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonDocument convert(RowData rowData) {
                return (BsonDocument)internalRowConverter.apply((Object)rowData);
            }
        };
    }

    public static SerializableFunction<Object, BsonValue> createFieldDataConverter(LogicalType type) {
        return RowDataToBsonConverters.createNullSafeInternalConverter(type);
    }

    private static SerializableFunction<Object, BsonValue> createNullSafeInternalConverter(LogicalType type) {
        return RowDataToBsonConverters.wrapIntoNullSafeInternalConverter(RowDataToBsonConverters.createInternalConverter(type), type);
    }

    private static SerializableFunction<Object, BsonValue> wrapIntoNullSafeInternalConverter(final SerializableFunction<Object, BsonValue> internalConverter, final LogicalType type) {
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            public BsonValue apply(Object value) {
                if (value == null || LogicalTypeRoot.NULL.equals((Object)type.getTypeRoot())) {
                    if (type.isNullable()) {
                        return BsonNull.VALUE;
                    }
                    throw new IllegalArgumentException("The column type is <" + type + ">, but a null value is being written into it");
                }
                return (BsonValue)internalConverter.apply(value);
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return BsonNull.VALUE;
                    }
                };
            }
            case BOOLEAN: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonBoolean((Boolean)value);
                    }
                };
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonInt32((Integer)value);
                    }
                };
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonInt64((Long)value);
                    }
                };
            }
            case DOUBLE: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonDouble((Double)value);
                    }
                };
            }
            case DECIMAL: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        BigDecimal decimalVal = ((DecimalData)value).toBigDecimal();
                        return new BsonDecimal128(new Decimal128(decimalVal));
                    }
                };
            }
            case CHAR: 
            case VARCHAR: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        String val = value.toString();
                        if (val.startsWith("{") && val.endsWith("}") && val.contains("_value")) {
                            try {
                                BsonDocument doc = BsonDocument.parse(val);
                                if (doc.containsKey("_value")) {
                                    return doc.get("_value");
                                }
                            }
                            catch (JsonParseException e) {
                                return new BsonString(value.toString());
                            }
                        }
                        return new BsonString(value.toString());
                    }
                };
            }
            case BINARY: 
            case VARBINARY: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonBinary((byte[])value);
                    }
                };
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonDateTime(((TimestampData)value).toTimestamp().getTime());
                    }
                };
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    public BsonValue apply(Object value) {
                        return new BsonDateTime(((TimestampData)value).getMillisecond());
                    }
                };
            }
            case ROW: {
                return RowDataToBsonConverters.createRowConverter((RowType)type);
            }
            case ARRAY: {
                return RowDataToBsonConverters.createArrayConverter((ArrayType)type);
            }
            case MAP: {
                return RowDataToBsonConverters.createMapConverter((MapType)type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    private static SerializableFunction<Object, BsonValue> createRowConverter(final RowType rowType) {
        final SerializableFunction[] fieldConverters = (SerializableFunction[])rowType.getChildren().stream().map(RowDataToBsonConverters::createNullSafeInternalConverter).toArray(SerializableFunction[]::new);
        LogicalType[] fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        final int fieldCount = rowType.getFieldCount();
        final RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)fieldTypes[i], (int)i);
        }
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            public BsonValue apply(Object value) {
                RowData rowData = (RowData)value;
                BsonDocument document = new BsonDocument();
                for (int i = 0; i < fieldCount; ++i) {
                    String fieldName = (String)rowType.getFieldNames().get(i);
                    Object fieldValue = fieldGetters[i].getFieldOrNull(rowData);
                    document.append(fieldName, (BsonValue)fieldConverters[i].apply(fieldValue));
                }
                return document;
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createArrayConverter(ArrayType arrayType) {
        LogicalType elementType = arrayType.getElementType();
        final ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)elementType);
        final SerializableFunction<Object, BsonValue> elementConverter = RowDataToBsonConverters.createNullSafeInternalConverter(elementType);
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            public BsonValue apply(Object value) {
                ArrayData arrayData = (ArrayData)value;
                ArrayList<BsonValue> bsonValues = new ArrayList<BsonValue>();
                for (int i = 0; i < arrayData.size(); ++i) {
                    BsonValue bsonValue = (BsonValue)elementConverter.apply(elementGetter.getElementOrNull(arrayData, i));
                    bsonValues.add(bsonValue);
                }
                return new BsonArray(bsonValues);
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createMapConverter(MapType mapType) {
        LogicalType keyType = mapType.getKeyType();
        LogicalType valueType = mapType.getValueType();
        if (!keyType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            throw new UnsupportedOperationException("MongoDB doesn't support non-string as key type of map. The type is: " + keyType.asSummaryString());
        }
        final SerializableFunction<Object, BsonValue> valueConverter = RowDataToBsonConverters.createNullSafeInternalConverter(valueType);
        final ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            public BsonValue apply(Object value) {
                MapData mapData = (MapData)value;
                ArrayData keyArray = mapData.keyArray();
                ArrayData valueArray = mapData.valueArray();
                BsonDocument document = new BsonDocument();
                for (int i = 0; i < mapData.size(); ++i) {
                    String key = keyArray.getString(i).toString();
                    BsonValue bsonValue = (BsonValue)valueConverter.apply(valueGetter.getElementOrNull(valueArray, i));
                    document.append(key, bsonValue);
                }
                return document;
            }
        };
    }

    @FunctionalInterface
    public static interface RowDataToBsonConverter
    extends Serializable {
        public BsonDocument convert(RowData var1);
    }
}

