/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.utils.MongoValidationUtils;
import org.apache.flink.connector.mongodb.table.converter.RowDataToBsonConverters;
import org.apache.flink.mongodb.shaded.org.bson.BsonObjectId;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.types.ObjectId;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;

@Internal
public class MongoKeyExtractor
implements SerializableFunction<RowData, BsonValue> {
    private static final long serialVersionUID = 1L;
    public static final String RESERVED_ID = "_id";
    private static final AppendOnlyKeyExtractor APPEND_ONLY_KEY_EXTRACTOR = new AppendOnlyKeyExtractor();
    private final int[] primaryKeyIndexes;
    private final SerializableFunction<Object, BsonValue> primaryKeyConverter;
    private final RowData.FieldGetter primaryKeyGetter;

    private MongoKeyExtractor(LogicalType primaryKeyType, int[] primaryKeyIndexes) {
        this.primaryKeyIndexes = primaryKeyIndexes;
        this.primaryKeyConverter = RowDataToBsonConverters.createFieldDataConverter(primaryKeyType);
        this.primaryKeyGetter = MongoKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes) ? rowData -> ProjectedRowData.from((int[])primaryKeyIndexes).replaceRow(rowData) : RowData.createFieldGetter((LogicalType)primaryKeyType, (int)primaryKeyIndexes[0]);
    }

    public BsonValue apply(RowData rowData) {
        String keyString;
        Object rowKeyValue = this.primaryKeyGetter.getFieldOrNull(rowData);
        Preconditions.checkNotNull((Object)rowKeyValue, (String)("Primary key value is null of RowData: " + rowData));
        BsonValue keyValue = (BsonValue)this.primaryKeyConverter.apply(rowKeyValue);
        if (!MongoKeyExtractor.isCompoundPrimaryKey(this.primaryKeyIndexes) && keyValue.isString() && ObjectId.isValid(keyString = keyValue.asString().getValue())) {
            keyValue = new BsonObjectId(new ObjectId(keyString));
        }
        return keyValue;
    }

    public static SerializableFunction<RowData, BsonValue> createKeyExtractor(ResolvedSchema resolvedSchema) {
        DataType primaryKeyType;
        Optional primaryKey = resolvedSchema.getPrimaryKey();
        int[] primaryKeyIndexes = resolvedSchema.getPrimaryKeyIndexes();
        Optional reservedId = resolvedSchema.getColumn(RESERVED_ID);
        if (!primaryKey.isPresent() && !reservedId.isPresent()) {
            return APPEND_ONLY_KEY_EXTRACTOR;
        }
        if (reservedId.isPresent() && (!primaryKey.isPresent() || MongoKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes) || !MongoKeyExtractor.primaryKeyContainsReservedId((UniqueConstraint)primaryKey.get()))) {
            throw new IllegalArgumentException("Ambiguous keys being used due to the presence of an _id field. Either use the _id column as the key, or rename the _id column.");
        }
        if (MongoKeyExtractor.isCompoundPrimaryKey(primaryKeyIndexes)) {
            DataType physicalRowDataType = resolvedSchema.toPhysicalRowDataType();
            primaryKeyType = Projection.of((int[])primaryKeyIndexes).project(physicalRowDataType);
        } else {
            int primaryKeyIndex = primaryKeyIndexes[0];
            Optional column = resolvedSchema.getColumn(primaryKeyIndex);
            if (!column.isPresent()) {
                throw new IllegalStateException(String.format("No primary key column found with index '%s'.", primaryKeyIndex));
            }
            primaryKeyType = ((Column)column.get()).getDataType();
        }
        MongoValidationUtils.validatePrimaryKey(primaryKeyType);
        return new MongoKeyExtractor(primaryKeyType.getLogicalType(), primaryKeyIndexes);
    }

    private static boolean isCompoundPrimaryKey(int[] primaryKeyIndexes) {
        return primaryKeyIndexes.length > 1;
    }

    private static boolean primaryKeyContainsReservedId(UniqueConstraint primaryKey) {
        return primaryKey.getColumns().contains(RESERVED_ID);
    }

    private static class AppendOnlyKeyExtractor
    implements SerializableFunction<RowData, BsonValue> {
        private static final long serialVersionUID = 1L;

        private AppendOnlyKeyExtractor() {
        }

        public BsonValue apply(RowData rowData) {
            return null;
        }
    }
}

