/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.MongoSink;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.table.converter.RowDataToBsonConverters;
import org.apache.flink.connector.mongodb.table.serialization.MongoRowDataSerializationSchema;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;

@Internal
public class MongoDynamicTableSink
implements DynamicTableSink {
    private final MongoConnectionOptions connectionOptions;
    private final MongoWriteOptions writeOptions;
    @Nullable
    private final Integer parallelism;
    private final boolean isUpsert;
    private final DataType physicalRowDataType;
    private final SerializableFunction<RowData, BsonValue> keyExtractor;

    public MongoDynamicTableSink(MongoConnectionOptions connectionOptions, MongoWriteOptions writeOptions, @Nullable Integer parallelism, boolean isUpsert, DataType physicalRowDataType, SerializableFunction<RowData, BsonValue> keyExtractor) {
        this.connectionOptions = (MongoConnectionOptions)Preconditions.checkNotNull((Object)connectionOptions);
        this.writeOptions = (MongoWriteOptions)Preconditions.checkNotNull((Object)writeOptions);
        this.parallelism = parallelism;
        this.isUpsert = isUpsert;
        this.physicalRowDataType = (DataType)Preconditions.checkNotNull((Object)physicalRowDataType);
        this.keyExtractor = (SerializableFunction)Preconditions.checkNotNull(keyExtractor);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (this.isUpsert) {
            return ChangelogMode.upsert();
        }
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        RowDataToBsonConverters.RowDataToBsonConverter rowDataToBsonConverter = RowDataToBsonConverters.createConverter((RowType)this.physicalRowDataType.getLogicalType());
        MongoRowDataSerializationSchema serializationSchema = new MongoRowDataSerializationSchema(rowDataToBsonConverter, (Function<RowData, BsonValue>)this.keyExtractor);
        MongoSink<RowData> mongoSink = MongoSink.builder().setUri(this.connectionOptions.getUri()).setDatabase(this.connectionOptions.getDatabase()).setCollection(this.connectionOptions.getCollection()).setBatchSize(this.writeOptions.getBatchSize()).setBatchIntervalMs(this.writeOptions.getBatchIntervalMs()).setDeliveryGuarantee(this.writeOptions.getDeliveryGuarantee()).setMaxRetries(this.writeOptions.getMaxRetries()).setSerializationSchema(serializationSchema).build();
        return SinkV2Provider.of(mongoSink, (Integer)this.parallelism);
    }

    public MongoDynamicTableSink copy() {
        return new MongoDynamicTableSink(this.connectionOptions, this.writeOptions, this.parallelism, this.isUpsert, this.physicalRowDataType, this.keyExtractor);
    }

    public String asSummaryString() {
        return "MongoDB";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDynamicTableSink that = (MongoDynamicTableSink)o;
        return Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.writeOptions, that.writeOptions) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.isUpsert, that.isUpsert) && Objects.equals(this.physicalRowDataType, that.physicalRowDataType);
    }

    public int hashCode() {
        return Objects.hash(this.connectionOptions, this.writeOptions, this.parallelism, this.isUpsert, this.physicalRowDataType);
    }
}

