/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.reader.emitter;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.mongodb.source.reader.deserializer.MongoDeserializationSchema;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplitState;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.util.Collector;

@Internal
public class MongoRecordEmitter<T>
implements RecordEmitter<BsonDocument, T, MongoSourceSplitState> {
    private final MongoDeserializationSchema<T> deserializationSchema;
    private final SourceOutputWrapper<T> sourceOutputWrapper;

    public MongoRecordEmitter(MongoDeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
        this.sourceOutputWrapper = new SourceOutputWrapper();
    }

    public void emitRecord(BsonDocument document, SourceOutput<T> output, MongoSourceSplitState splitState) throws Exception {
        splitState.updateOffset(document);
        ((SourceOutputWrapper)this.sourceOutputWrapper).setSourceOutput(output);
        this.deserializationSchema.deserialize(document, this.sourceOutputWrapper);
    }

    private static class SourceOutputWrapper<T>
    implements Collector<T> {
        private SourceOutput<T> sourceOutput;

        private SourceOutputWrapper() {
        }

        public void collect(T record) {
            this.sourceOutput.collect(record);
        }

        public void close() {
        }

        private void setSourceOutput(SourceOutput<T> sourceOutput) {
            this.sourceOutput = sourceOutput;
        }
    }
}

